package com.baijia.tianxiao.sal.wechat.dto.templatemsg.growthdoc;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.Color;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;
import com.baijia.tianxiao.util.date.DateUtil;

import org.apache.commons.lang3.StringUtils;

import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.sf.json.JSONObject;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)> 新增成长记录消息
 * @since 13/09/2017 11:30 AM
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GrowthDocNewMsgToStu extends WechatTemplateMsg {

    private Integer orgId;
    private String openId;

    private String studentName;
    private String operatorName;
    private Long operatTime;
    private String content;

    public GrowthDocNewMsgToStu() {
        this.msgType = WechateTemplateMsgType.GROWTHDOC_NEW_TO_STU;
    }

    public String buildTemplateMsg(String templateId) {
        this.first = String.format("%s同学，%s老师为你添加了一条成长记录，点击查看吧~\n\n", studentName, operatorName);
        this.remark = "\n请点击消息查看并分享成长记录~";

        JSONObject data = new JSONObject();
        data.put("keyword1",
            getTemplateMsgNode(StringUtils.defaultIfBlank(content, "老师为你添加了图片语音记录"), Color.GREY_LIGTH));
        data.put("keyword2", getTemplateMsgNode(DateUtil.getStrByDateFormate(new Date(operatTime), "yyyy年M月d日 HH:mm"),
            Color.GREY_LIGTH));

        return super.buildBaseTemplateMsg(openId, templateId, data, Color.TIANXIAO_BLUE).toString();
    }

    public static GrowthDocNewMsgToStu fromJsonStr(String jsonStr) {
        GrowthDocNewMsgToStu msg = new GrowthDocNewMsgToStu();
        JSONObject json = JSONObject.fromObject(jsonStr);
        msg.fillBaseInfo(jsonStr);
        msg.setOrgId(json.optInt("orgId"));
        msg.setOpenId(json.getString("openId"));

        msg.setStudentName(json.optString("studentName"));
        msg.setOperatorName(json.optString("operatorName"));
        msg.setOperatTime(json.optLong("operatTime"));
        msg.setContent(json.optString("content"));
        return msg;
    }

    public String toJsonStr() {
        JSONObject json = super.getBaseJson();
        json.put("orgId", checkNull(this.orgId));
        json.put("openId", checkNull(this.openId));

        json.put("studentName", checkNull(this.studentName));
        json.put("operatorName", checkNull(this.operatorName));
        json.put("operatTime", checkNull(this.operatTime));
        json.put("content", checkNull(this.content));

        return json.toString();
    }
}
