/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg;

import net.sf.json.JSONObject;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.util.RandomUtil;

import lombok.Data;

/**   
 * @title       : WechatTemplateMsg 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年1月6日 上午12:01:08 
 */
@Data
public class WechatTemplateMsg {
	
	public static final String JSON_KEY_MSG_TYPE = "msgType";
	
	protected WechateTemplateMsgType msgType; //WechateTemplateMsgType
	protected String first;//模板消息 标题下面的第一行 类似于概要说明
	protected String remark;//模板消息 最尾一行
	protected String url;//跳转链接
	
	@SuppressWarnings("unused")
	private void setMsgType(WechateTemplateMsgType msgType){}
	
	
	protected void fillBaseInfo(String jsonStr){
		JSONObject json = JSONObject.fromObject(jsonStr);
		this.msgType = WechateTemplateMsgType.getByVaule(json.getInt("msgType")) ;
		this.first = json.optString("first","");
		this.remark = json.optString("remark","");
		this.url =  json.optString("url",null);
	}
	
	
	protected JSONObject getBaseJson(){
		JSONObject json = new JSONObject();
		json.put("msgType", this.msgType.getValue());
		json.put("first", this.first);
		json.put("remark", this.remark);
		json.put("url", this.url);
		return json;
	}
	
	
	
	protected JSONObject buildBaseTemplateMsg(String openId, String templateId, JSONObject data){
		return buildBaseTemplateMsg(openId, templateId, data, Color.BLACK_LIGHT);
	}
	
	protected JSONObject buildBaseTemplateMsg(String openId, String templateId, JSONObject data, String color){
		JSONObject json = new JSONObject();
		json.put("touser", openId);
		json.put("template_id", templateId);
		json.put("url", url);
		json.put("topcolor", Color.BLACK_LIGHT);
		
		data.put("first",  getTemplateMsgNode( first, color) );
		data.put("remark", getTemplateMsgNode( remark, color) );
		json.put("data", data);
		
		return json;
	}
	
	
	protected Object checkNull(Object obj){
		if(obj==null){
			return "null";
		}
		return obj;
	}
	
	protected static JSONObject getTemplateMsgNode(String value,String color){
		JSONObject obj = new JSONObject();
		obj.put("value", value);
		obj.put("color", color);
		return obj;
	}
	
	protected static JSONObject getTemplateMsgNode(String value){
		return getTemplateMsgNode(value,Color.BLACK_LIGHT);
	}
	
	
/**
	模板示例
		{{first.DATA}}
		课程名称：{{keyword1.DATA}}
		上课时间：{{keyword2.DATA}}
		上课地点：{{keyword3.DATA}}
		{{remark.DATA}}
	
	数据填充示例
		您预订的课程信息
		课程名称：Introduce
		上课时间：2015-07-15 星期三 19:00-20:00
		上课地点：深圳罗湖中心
		请提前做好课程预习，提前15分钟到达上课中心。
*/
	
	
	protected static String randomMsgNumber(){
        return RandomUtil.str(10);  
    }  
	
}

