/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant.qrcode;

import lombok.Getter;
import lombok.Setter;

/**   
 * @title       : WechatQRCodeType 
 * @description : 二维码类型 
 * @author      : zhenyujian
 * @date        : 2016年1月28日 上午11:40:24 
 */
public enum QRCodeType{
	
	CUSTOM_ACTIVITY("activity"),
	
	SUBCRIBE_WITH_ORG_ID("orgid"),
	
	QR_SCENE("txscene"),
	;

    private final String value;
	
	//@Setter
    //@Getter
    // 数据传输使用
    // FIXME 诶呀卧槽 枚举是单例的, 这个有并发问题啊啊
    //private Long sceneId;
    
    public static QRCodeType getByVaule(String value){
		for (QRCodeType type : QRCodeType.values()) {
			if(type.getValue().equals(value)){
				return type;
			}
        }
    	return null;
    }
    
    QRCodeType(String value) {
        this.value = value;
    }
    public String getValue() {
        return this.value;
    }
}

