
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.tianxiao.sal.wechat.dto.templatemsg.Color;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time May 10, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class WeixinTemplateContext {

    public static final String FIRST = "first";
    public static final String REMARK = "remark";
    public static final String TOP_COLOR = "topcolor";
    public static final String TO_USER = "touser";
    public static final String TEMPLATE_ID = "template_id";
    public static final String URL = "url";
    public static final String DATA = "data";

    private JSONObject json = new JSONObject();
    private JSONObject data = new JSONObject();
    private String topcolor = Color.BLACK_LIGHT;
    private String touser = "";
    private String templateId = "";
    private String url = "";

    public WeixinTemplateContext setTopcolor(String color) {
        if (GenericsUtils.isNullOrEmpty(color)) {
            color = Color.BLACK_LIGHT;
        }
        this.topcolor = color;
        return this;
    }

    public WeixinTemplateContext setToUser(String toUser) {
        this.touser = toUser;
        return this;
    }

    public WeixinTemplateContext setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public WeixinTemplateContext setUrl(String url) {
        this.url = url;
        return this;
    }

    public WeixinTemplateContext setFirst(String value, String color) {
        this.data.put(FIRST, WeixinUtils.getTemplateMsgNode(value, color));
        return this;
    }

    public WeixinTemplateContext setFirst(String value) {
        return this.setFirst(value, "");
    }

    public WeixinTemplateContext setRemark(String value, String...color) {
        String colorTmp = getColor(color);
        WeixinUtils.getTemplateMsgNode(value, colorTmp);
        return this;
    }

    public WeixinTemplateContext addNode(String key, String value, String...color) {
        if (GenericsUtils.isNullOrEmpty(key)) {
            log.debug("key is null or empty for value:{} ", value);
            return this;
        }
        String colorTmp = getColor(color);
        this.data.put(key, WeixinUtils.getTemplateMsgNode(value, colorTmp));
        return this;
    }

    /**
     * @param color
     * @return
     */

    private String getColor(String...color) {
        String colorTmp = GenericsUtils.isNullOrEmpty(color) ? "" : color[0];
        return colorTmp;
    }

    public static WeixinTemplateContext instance() {
        return new WeixinTemplateContext();
    }

    public JSONObject createData() {
        json.put(TO_USER, this.touser);
        json.put(TEMPLATE_ID, this.templateId);
        json.put(URL, this.url);
        json.put(TOP_COLOR, this.topcolor);
        json.put(DATA, this.data);
        return json;
    }

}
