package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.vzhibo.constant.TxVZhiBoInviteeInviterType;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoInviteeDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoInvitee;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.wechat.constant.QRCodeSceneBizType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.QRCodeScene;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.common.dto.InviteCardTaskDto;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.WechatQrSceneHandler;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSCANEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSubscribeEventMessage;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 07/06/2017 11:37 AM
 */
@Slf4j
@Service
public class WechatQrSceneHandlerImpl implements WechatQrSceneHandler {

    @Autowired
    private TxVZhiBoInviteeDao txVZhiBoInviteeDao;
    @Autowired
    private TxVZhiBoLessonDao txVZhiBoLessonDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    private static final String VZHIBO_QR_CODE_SCAN_RESP =
        "您已接受%s的邀请，获得【%s】的听课资格，点击立即进入直播\n\n您的专属邀请卡正在生成中，收到后请分享给好友，邀请大家一起来听课吧~";
    private static final String LINK_STR = "<a href='%s'>%s</a>";

    @Override
    public String handle(QRCodeScene scene, WechatEventMessage message) {
        switch (message.getEvent()) {
            // 订阅这个公众号
            case SUBSCRIBE: {
                WechatSubscribeEventMessage subscribeMsg = (WechatSubscribeEventMessage) message;
                if (scene.getBizType() == QRCodeSceneBizType.VZHIBO_INVITECARD.getCode()) {
                    // 微直播类型scene
                    return vzhiboEventProcess(scene, message);
                } else if (scene.getBizType() == QRCodeSceneBizType.ORG_PERMANENT_PARAM_QRCODE.getCode()) {
                    // 微信管家微信二维码分享卡
                    return orgParamQrcodeProcess(scene, message);
                }
                break;
            }
            // 已经订阅,扫码公众号
            case SCAN: {
                WechatSCANEventMessage scanMsg = (WechatSCANEventMessage) message;
                if (scene.getBizType() == QRCodeSceneBizType.VZHIBO_INVITECARD.getCode()) {
                    // 微直播类型scene
                    return vzhiboEventProcess(scene, message);
                } else if (scene.getBizType() == QRCodeSceneBizType.ORG_PERMANENT_PARAM_QRCODE.getCode()) {
                    // 微信管家微信二维码分享卡
                    return orgParamQrcodeProcess(scene, message);
                }
                break;
            }
        }
        return "";
    }

    // FIXME 没认证的公众号,没有邀请卡功能
    private String getLiveLessonUrl(Integer orgId, Long lessonId) {
        OrgAccount orgAccount = orgAccountDao.getById(orgId);
        if (orgAccount == null) {
            return "";
        }
        AuthorizationInfo authorizationInfo = authorizationInfoService.getByOrgId(orgAccount.getId());
        if (null != authorizationInfo) {
            String appId = authorizationInfo.getAuthorizerAppId();
            String lessonLiveUrl = PropertiesReader.getValue("config", "lesson_live_url");
            String redirectUrl = lessonLiveUrl.replace("{orgNumber}", orgAccount.getNumber().toString())
                .replace("{lessonId}", lessonId.toString());
            return WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, appId, redirectUrl);
        } else {
            return "";
        }
    }

    private String getHrefLink(String href, String content) {
        return String.format(LINK_STR, href, content);
    }

    private String orgParamQrcodeProcess(QRCodeScene qrCodeScene, WechatEventMessage message) {
        AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(message.getToUserName());
        Integer orgId = authorizerInfo.getOrgId();
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        OrgWechatDto owDto = new OrgWechatDto(orgId, orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        StringBuilder content = new StringBuilder();
        content.append("欢迎您绑定").append(orgInfo.getShortName()).append("的学生个人中心！").append("\n\n");
        content.append("1.查看详细的成长档案\n");
        content.append("2.查看课表、评价、签到、课时\n");
        content.append("3.接收各类消息通知\n\n");
        content.append(getHrefLink(MediaType.XUESHENGZHONGXIN.getUrl(owDto), "点击进入学生中心>>"));
        return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
    }

    private String getInviterName(Integer orgId, TxVZhiBoInvitee invitee) {
        if (TxVZhiBoInviteeInviterType.MASTER.getCode() == invitee.getInviterType()) {
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(invitee.getInviterId());
            return orgInfo.getContacts();
        } else if (TxVZhiBoInviteeInviterType.CASCADE.getCode() == invitee.getInviterType()) {
            TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(invitee.getInviterId(), "credentialId");
            TXCascadeCredential cascadeCredential =
                txCascadeCredentialDao.getById(cascadeAccount.getCredentialId(), "name");
            return cascadeCredential.getName();
        } else {
            OrgStudent orgStudent = null;
            // 再看是否已经是学员
            List<OrgStudent> orgStudents =
                orgStudentDao.getStudentByOpenIdAndOrgId(orgId.longValue(), invitee.getInviterOpenId());
            if (CollectionUtils.isNotEmpty(orgStudents)) {
                orgStudent = orgStudents.get(0);
            }
            if (null != orgStudent) {
                return orgStudent.getName();
            }

            TxConsultUser consult = null;
            List<TxConsultUser> consultUsers =
                consultUserDao.lookByWeixinOpenId(orgId.longValue(), invitee.getInviterOpenId());
            if (CollectionUtils.isNotEmpty(orgStudents)) {
                consult = consultUsers.get(0);
            }
            if (null != consult && consult.getIsConsulter() != null
                && consult.getIsConsulter() == Flag.FALSE.getInt()) {
                return consult.getName();
            }

            Fans fans = fansDao.getByOpenId(invitee.getInviterOpenId());
            return fans.getNick();
        }
    }

    private String vzhiboEventProcess(QRCodeScene scene, WechatEventMessage message) {
        String openId = message.getFromUserName();
        // 先保存邀请信息
        TxVZhiBoInvitee invitee = txVZhiBoInviteeDao.getBySceneIdAndOpenId(scene.getId(), openId);
        if (null == invitee) {
            invitee = new TxVZhiBoInvitee();
            invitee.setSceneId(scene.getId().intValue());
            invitee.setInviterType(scene.getRoleType());
            invitee.setInviterId(scene.getRoleId());
            invitee.setInviterOpenId(scene.getRoleStr());
            invitee.setLessonId(scene.getBizId());
            invitee.setOpenId(openId);
            invitee.setCreateTime(new Date());
            invitee.setUpdateTime(invitee.getCreateTime());
            txVZhiBoInviteeDao.save(invitee);
        }
        TxVZhiBoLesson txVZhiBoLesson = txVZhiBoLessonDao.getById(invitee.getLessonId());
        InviteCardTaskDto taskDto = new InviteCardTaskDto(txVZhiBoLesson.getId().intValue(), openId, true);
        this.redisTemplate.opsForList().rightPush(RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(),
            taskDto.toJson());
        String lessonName = txVZhiBoLesson.getName();
        String inviterName = this.getInviterName(txVZhiBoLesson.getOrgId(), invitee);
        String vzhiboLink = this.getLiveLessonUrl(txVZhiBoLesson.getOrgId(), txVZhiBoLesson.getId());
        if (StringUtils.isEmpty(vzhiboLink)) {
            return "";
        }
        String content =
            String.format(VZHIBO_QR_CODE_SCAN_RESP, inviterName, String.format(LINK_STR, vzhiboLink, lessonName));
        return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content);
    }
}
