/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.Date;

import lombok.extern.slf4j.Slf4j;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.dao.PreAuthCodeDao;
import com.baijia.tianxiao.dal.wechat.po.PreAuthCode;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.sal.wechat.api.PreAuthCodeService;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.openplat.OpenPlatApiHelper;

/**   
 * @Title       : PreAuthCodeServiceImpl 
 * @Description : 
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 下午2:05:59 
 */
@Service
@Slf4j
public class PreAuthCodeServiceImpl implements PreAuthCodeService {

    private static final Logger logger = LoggerFactory.getLogger(PreAuthCodeServiceImpl.class);

    @Autowired
    private PreAuthCodeDao preAuthCodeDao;
    @Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;
    
    
    
    @Transactional(readOnly=true)
    @Override
    public PreAuthCode get() {
        String appId = WechatProperties.getOpenAppId();
        PreAuthCode newPreAuthCode = null;
        try{
	        String componentAccessToken = componentAccessTokenDao.getByAppId(appId).getComponentAccessToken();
	        newPreAuthCode = OpenPlatApiHelper.requestPreAuthCode(appId, componentAccessToken);
        }catch(Exception e){
        	log.error("PreAuthCode - refresh - exception",e);
        	throw new PermissionException("刷新预授权码失败,请重新访问。");
        }
        return newPreAuthCode;
    }

    
    
    @Transactional(readOnly=true)
    @Override
    public PreAuthCode getByAppId(String appId) {
        return preAuthCodeDao.getByAppId(appId);
    }

    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update() {
    	String appId = WechatProperties.getOpenAppId();
        String componentAccessToken = componentAccessTokenDao.getByAppId(appId).getComponentAccessToken();
        PreAuthCode newPreAuthCode = OpenPlatApiHelper.requestPreAuthCode(appId, componentAccessToken);;

        PreAuthCode preAuthCode = getByAppId(appId);
        if (preAuthCode == null) {
            preAuthCodeDao.save(newPreAuthCode,true);
            logger.info("wechat - add new preauthcode:{}", newPreAuthCode);
            return;
        }else{
        	preAuthCode.setUpdateTime(new Date());
            preAuthCode.setExpiresIn(newPreAuthCode.getExpiresIn());
            preAuthCode.setPreAuthCode(newPreAuthCode.getPreAuthCode());
            preAuthCodeDao.update(preAuthCode,true);
            logger.info("wechat - update preauthcode:{}", preAuthCode);
            return;
        }
    }

}
