/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.sal.wechat.constant.wechatmsg.WechatMsgEvent;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;

/**
 * @title : WechatEventMessage
 * @description :
 * @author : zhenyujian
 * @date : 2016年1月11日 下午10:56:35
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class WechatEventMessage extends WechatAbstractMessage {

    private WechatMsgEvent event;
    /**
     * @1:当用户扫描带场景值的二维码时,如果用户已经关注了该公众号,微信服务号会像公众号服务器推送一条时间类型为scan的信息.<br/>
     * @2:事件KEY值,与自定义菜单接口中KEY值对应
     */
    private String eventKey;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
