/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.webauth;

import com.baijia.tianxiao.dto.BaseDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import net.sf.json.JSONObject;
import lombok.Data;


/**   
 * @title       : WebAuthorizationDto 
 * @description : 微信网页授权授权记录
 * @author      : zhenyujian
 * @date        : 2016年1月6日 下午8:06:52 
 */
@Data
public class WebAuthorizationDto{
	
	private String accessToken;
	private Integer expiresIn;
	private String refreshToken;
	private String openid;
	private String scope;
	private String unionid;
	
	
	public static WebAuthorizationDto fromJson(String json){
		WebAuthorizationDto dto = new WebAuthorizationDto();
		JSONObject jsonObj = JSONObject.fromObject(json);
		
		String accessToken = jsonObj.getString("access_token");
		Integer expiresIn = jsonObj.getInt("expires_in");
		String refreshToken = jsonObj.getString("refresh_token");
		String openid = jsonObj.getString("openid");
		String scope = jsonObj.getString("scope");
		
		dto.setAccessToken(accessToken);
		dto.setExpiresIn(expiresIn);
		dto.setRefreshToken(refreshToken);
		dto.setOpenid(openid);
		dto.setScope(scope);
		return dto;
	}
	
	
	@Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

