/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.evaluation;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;

import net.sf.json.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**   
 * @title       : CourseStartNoticeMsg 
 * @description : 老师评语 - 学生
 * @author      : zhenyujian
 * @date        : 2016年1月5日 下午9:05:03 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class TeacherEvaluationMsgToStu extends WechatTemplateMsg{
	
	private Integer orgId;
	private String openId;
	
	private String orgName;
	private String courseName;
	private String studentName;
	private String teacherName;
	private Integer lessonNo;
	private Long evaluateTime;
	
	
	public TeacherEvaluationMsgToStu(){
		this.msgType = WechateTemplateMsgType.TEACHER_EVALUATION_TO_STU;
	}
	
	
	/**
	 * @Description  : 创建微信模板消息 用于调用微信api
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:50:29 
	 *
	 * @Return       : String
	 */
	public String buildTemplateMsg(String templateId){
		this.first = String.format("【%s】,你好:\n\n老师点评了你在【%s】【第%s次课】的表现。\n",
									studentName, courseName, lessonNo);
		this.remark = "\n点击查看完整评语内容。";
		
		JSONObject data = new JSONObject();
		data.put("keyword1", getTemplateMsgNode( studentName ) );
		data.put("keyword2", getTemplateMsgNode( courseName ) );
		data.put("keyword3", getTemplateMsgNode( teacherName ) );
		
		return super.buildBaseTemplateMsg(openId, templateId, data).toString();
	}
	
	
	
	/**
	 * @Description  : json转换成对象
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:30 
	 *
	 * @Return       : CourseStartNoticeMsg
	 */
	public static TeacherEvaluationMsgToStu fromJsonStr(String jsonStr){
		TeacherEvaluationMsgToStu msg = new TeacherEvaluationMsgToStu();
		
		JSONObject json = JSONObject.fromObject(jsonStr);
		msg.fillBaseInfo(jsonStr);
		msg.setOrgId( json.optInt("orgId") );
		msg.setOpenId( json.getString("openId"));

		msg.setOrgName( json.optString("orgName") );
		msg.setCourseName( json.optString("courseName") );
		msg.setStudentName( json.optString("studentName") );
		msg.setTeacherName( json.optString("teacherName") );
		msg.setLessonNo( json.optInt("lessonNo") );
		msg.setEvaluateTime( json.optLong("evaluateTime") );

		return msg;
	}
	
	
	
	/**
	 * @Description  : 对象转换成json
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:38 
	 *
	 * @Return       : String
	 */
	public String toJsonStr(){
		JSONObject json = super.getBaseJson();
		json.put("orgId", checkNull(this.orgId) );
		json.put("openId", checkNull(this.openId));

		json.put("orgName", checkNull(this.orgName));
		json.put("courseName", checkNull(this.courseName));
		json.put("studentName", checkNull(this.studentName));
		json.put("teacherName", checkNull(this.teacherName));
		json.put("lessonNo", checkNull(this.lessonNo));
		json.put("evaluateTime", checkNull(this.evaluateTime));
		
		return json.toString();
	}
	
	
	public void setOrgId(Integer orgId){
		this.orgId = orgId;
	}
	public void setOrgId(Long orgId){
		this.orgId = Integer.parseInt(orgId.toString());
	}
}

