/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.statistics;

import lombok.Data;

/**   
 * @title       : FasnSummaryDto
 * @description : 微信粉丝累计用户数据
 * 				  http://mp.weixin.qq.com/wiki/15/88726a421bfc54654a3095821c3ca3bb.html
 * @author      : zhenyujian
 * @date        : 2015年12月18日 下午4:59:08 
 */
@Data
public class FansSummaryDto {
	 
    private String date; //日期 "yyyy-MM-dd"
	private int newFans;//新增关注用户(粉丝)
	private int cancelFans;//取消关注的用户(粉丝)
	private int fansDiff;//净增粉丝数
	
	private boolean flag = false; //是否从微信拉取到了数据
	
	public FansSummaryDto(){
	}
	
	public FansSummaryDto(String date){
		this.date = date;
	}
	
}

