package com.baijia.tianxiao.sal.wechat.dto.qrcode;

import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.StringUtils;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 27/09/2017 3:27 PM
 */
@Data
@EqualsAndHashCode
public class QRCodeSceneStrSceneId extends QRCodeSceneStr {
    private static final String JSON_KEY_SCENE_ID = "sceneId";
    private static final String JSON_KEY_ORG_ID = "orgId";

    private Long sceneId;
    private Long orgId;

    public QRCodeSceneStrSceneId() {
        super.qrCodeType = QRCodeType.QR_SCENE;
    }

    public QRCodeSceneStrSceneId(Long orgId, Long sceneId) {
        this();
        this.orgId = orgId;
        this.sceneId = sceneId;
    }

    public String getSceneStr() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getSceneStr());
        builder.append(QRCodeSceneStr.createSceneStrParam(JSON_KEY_ORG_ID, this.orgId));
        builder.append(QRCodeSceneStr.createSceneStrParam(JSON_KEY_SCENE_ID, this.sceneId));
        return builder.toString();
    }

    public static QRCodeSceneStrSceneId fromSceneStr(String str) {
        Long sceneId = null;
        Long orgId = null;
        if (StringUtils.isNumeric(str)) {
            sceneId = Long.valueOf(str);
        } else if (str.startsWith("qrscene_") && StringUtils.isNumeric(str.replace("qrscene_", ""))) {
            str = str.replace("qrscene_", "");
            sceneId = Long.valueOf(str);
        }else {
            String sceneIdStr = QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_SCENE_ID);
            String orgIdStr = QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_ORG_ID);
            sceneId = StringUtils.isNumeric(sceneIdStr) ? Long.parseLong(sceneIdStr) : null;
            orgId = StringUtils.isNumeric(orgIdStr) ? Long.parseLong(orgIdStr) : null;
        }
        return new QRCodeSceneStrSceneId(orgId, sceneId);
    }
}
