package com.baijia.tianxiao.sal.wechat.api;

import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;


/**   
 * @title       : WechatFreeVersionService 
 * @description : 免费版公众号
 * @author      : zhenyujian
 * @date        : 2016年11月11日 下午3:58:08 
 */
public interface WechatFreeVersionService {

	/**
	 * @Description  : 判断机构是否是免费版账号
	 * @Author       : zhenyujian
	 */
	boolean isFreeAccount(Integer orgId);
	
	
	/**
	 * @Description  : 判断机构是否是免费版账号
	 * @Author       : zhenyujian
	 */
	boolean isFreeAccount(String appId);
	
	
	/**
	 * @Description  : 获取免费版公众号信息
	 * @Author       : zhenyujian
	 */
	AuthorizerInfo getFAAuthorizerInfo();
	
	
	/**
	 * @Description  : 判断机构是否是免费版账号 或是 付费版且没有绑定公众号
	 * @Author       : zhenyujian
	 */
	boolean isFreeAccountOrUnBindWechatApp(Integer orgId);
	
}

