/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import java.io.File;
import java.util.List;

import com.baijia.tianxiao.dal.wechat.constant.WechatMediaNewsType;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMediaNews;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaNewsDto;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaUploadResultDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;


/**   
 * @title       : MediaService 
 * @description : 素材管理(永久素材)
 * @author      : zhenyujian
 * @date        : 2015年12月24日 下午2:24:15 
 */
public interface MediaService {
	
	/**
	 * @Description  : 判断是否需要同步素材列表
	 * @Author       : zhenyujian
	 */
	boolean isNeedToSync(int orgId);
	
	
	/**
	 * @Description  : 数据同步(从微信同步到本地) 图文素材
	 * @Author       : zhenyujian
	 */
	public void syncMediaNews(String authorizerAppId);
	
	
	/**
	 * @Description  : 分页查询 图文素材
	 * @Author       : zhenyujian
	 */
	List<MediaNewsDto> listPermanentMediaNews(int orgId, PageDto pageDto);
	
	
	/**
	 * @Description  : 查询 图文素材
	 * @Author       : zhenyujian
	 */
	MediaNewsDto getPermanentMediaNews(int orgId, String mediaId);
	
	
	/**
	 * @Description  : 上传微信永久图片素材 (上传到微信)
	 * @Author       : zhenyujian
	 */
	MediaUploadResultDto uploadPermanentMediaImage(int orgId, String imageUrl, File imageFile);
	
	
	/**
	 * @Description  : 上传微信永久图片素材 (上传到微信)
	 * @Author       : zhenyujian
	 */
	MediaUploadResultDto uploadPermanentMediaImage(int orgId, String imageUrl) throws Exception;
	
	
	/**
	 * @Description  : 上传微信永久图文素材 (上传到微信)
	 * @Author       : zhenyujian
	 */
	MediaUploadResultDto uploadPermanentMediaNews(int orgId, String json) throws Exception;
	
	MediaUploadResultDto uploadPermanentMediaNews(int orgId, String json, WechatMediaNewsType type) throws Exception;
	
	
	
	/**
	 * @Description  : 删除素材 微信端 本地数据库 均删除
	 * @Author       : zhenyujian
	 * @Date         : 2016年3月21日 下午5:14:09 
	 *
	 * @Return       : void
	 */
	void delMedia(Integer orgId, String mediaId);
	
	
	
	/**
	 * @Description  : 批量插入 图文素材
	 * @Author       : zhenyujian
	 * @Date         : 2016年3月24日 下午4:11:45 
	 *
	 * @Return       : void
	 */
	void batchSaveMediaNews(List<OrgWechatMediaNews> list);
	
}

