/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import com.baijia.tianxiao.sal.wechat.dto.request.AuthorizationInfoCallbackRequest;


/**   
 * @title       : AuthorizationInfoCallbackHandler 
 * @description : 公众号绑定(授权)流程 回调(使用authCode获取授权信息)
 * @author      : zhenyujian
 * @date        : 2015年12月12日 下午8:39:49 
 */
public interface AuthorizationInfoCallbackHandler {

    /**
     * @Description  : 公众号在微信授权成功后回调此方法 记录授权成功记录及进行一些数据初始化操作 
     * @Author       : zhenyujian
     */
    void handle(AuthorizationInfoCallbackRequest request);
    
    
    /**
     * @Description  : 公众号在微信授权成功后回调此方法 记录授权成功记录及进行一些数据初始化操作 (全网发布测试时调用)
     * @Author       : zhenyujian
     */
    void handleTest(AuthorizationInfoCallbackRequest request);
}
