/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.vzhibo.constant.TxVZhiBoInviteeInviterType;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoInviteeDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoInvitee;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.wechat.constant.QRCodeSceneBizType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.QRCodeScene;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.common.dto.InviteCardTaskDto;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.WechatQrSceneHandler;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSCANEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSubscribeEventMessage;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class WechatQrSceneHandlerImpl
implements WechatQrSceneHandler {
    private static final Logger log = LoggerFactory.getLogger(WechatQrSceneHandlerImpl.class);
    @Autowired
    private TxVZhiBoInviteeDao txVZhiBoInviteeDao;
    @Autowired
    private TxVZhiBoLessonDao txVZhiBoLessonDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private static final String VZHIBO_QR_CODE_SCAN_RESP = "\u60a8\u5df2\u63a5\u53d7%s\u7684\u9080\u8bf7\uff0c\u83b7\u5f97\u3010%s\u3011\u7684\u542c\u8bfe\u8d44\u683c\uff0c\u70b9\u51fb\u7acb\u5373\u8fdb\u5165\u76f4\u64ad\n\n\u60a8\u7684\u4e13\u5c5e\u9080\u8bf7\u5361\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u6536\u5230\u540e\u8bf7\u5206\u4eab\u7ed9\u597d\u53cb\uff0c\u9080\u8bf7\u5927\u5bb6\u4e00\u8d77\u6765\u542c\u8bfe\u5427~";
    private static final String LINK_STR = "<a href='%s'>%s</a>";

    @Override
    public String handle(QRCodeScene scene, WechatEventMessage message) {
        switch (message.getEvent()) {
            case SUBSCRIBE: {
                WechatSubscribeEventMessage subscribeMsg = (WechatSubscribeEventMessage)message;
                if (scene.getBizType().intValue() == QRCodeSceneBizType.VZHIBO_INVITECARD.getCode()) {
                    return this.vzhiboEventProcess(scene, message);
                }
                if (scene.getBizType().intValue() != QRCodeSceneBizType.ORG_PERMANENT_PARAM_QRCODE.getCode()) break;
                return this.orgParamQrcodeProcess(scene, message);
            }
            case SCAN: {
                WechatSCANEventMessage scanMsg = (WechatSCANEventMessage)message;
                if (scene.getBizType().intValue() == QRCodeSceneBizType.VZHIBO_INVITECARD.getCode()) {
                    return this.vzhiboEventProcess(scene, message);
                }
                if (scene.getBizType().intValue() != QRCodeSceneBizType.ORG_PERMANENT_PARAM_QRCODE.getCode()) break;
                return this.orgParamQrcodeProcess(scene, message);
            }
        }
        return "";
    }

    private String getLiveLessonUrl(Integer orgId, Long lessonId) {
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (orgAccount == null) {
            return "";
        }
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByOrgId(orgAccount.getId());
        if (null != authorizationInfo) {
            String appId = authorizationInfo.getAuthorizerAppId();
            String lessonLiveUrl = PropertiesReader.getValue((String)"config", (String)"lesson_live_url");
            String redirectUrl = lessonLiveUrl.replace("{orgNumber}", orgAccount.getNumber().toString()).replace("{lessonId}", lessonId.toString());
            return WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, appId, redirectUrl);
        }
        return "";
    }

    private String getHrefLink(String href, String content) {
        return String.format(LINK_STR, href, content);
    }

    private String orgParamQrcodeProcess(QRCodeScene qrCodeScene, WechatEventMessage message) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        Integer orgId = authorizerInfo.getOrgId();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        OrgWechatDto owDto = new OrgWechatDto(orgId, orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        StringBuilder content = new StringBuilder();
        content.append("\u6b22\u8fce\u60a8\u7ed1\u5b9a").append(orgInfo.getShortName()).append("\u7684\u5b66\u751f\u4e2a\u4eba\u4e2d\u5fc3\uff01").append("\n\n");
        content.append("1.\u67e5\u770b\u8be6\u7ec6\u7684\u6210\u957f\u6863\u6848\n");
        content.append("2.\u67e5\u770b\u8bfe\u8868\u3001\u8bc4\u4ef7\u3001\u7b7e\u5230\u3001\u8bfe\u65f6\n");
        content.append("3.\u63a5\u6536\u5404\u7c7b\u6d88\u606f\u901a\u77e5\n\n");
        content.append(this.getHrefLink(MediaType.XUESHENGZHONGXIN.getUrl(owDto), "\u70b9\u51fb\u8fdb\u5165\u5b66\u751f\u4e2d\u5fc3>>"));
        return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
    }

    private String getInviterName(Integer orgId, TxVZhiBoInvitee invitee) {
        if (TxVZhiBoInviteeInviterType.MASTER.getCode() == invitee.getInviterType().intValue()) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(invitee.getInviterId(), new String[0]);
            return orgInfo.getContacts();
        }
        if (TxVZhiBoInviteeInviterType.CASCADE.getCode() == invitee.getInviterType().intValue()) {
            TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)invitee.getInviterId(), new String[]{"credentialId"});
            TXCascadeCredential cascadeCredential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[]{"name"});
            return cascadeCredential.getName();
        }
        OrgStudent orgStudent = null;
        List orgStudents = this.orgStudentDao.getStudentByOpenIdAndOrgId(Long.valueOf(orgId.longValue()), invitee.getInviterOpenId(), new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgStudents)) {
            orgStudent = (OrgStudent)orgStudents.get(0);
        }
        if (null != orgStudent) {
            return orgStudent.getName();
        }
        TxConsultUser consult = null;
        List consultUsers = this.consultUserDao.lookByWeixinOpenId(Long.valueOf(orgId.longValue()), invitee.getInviterOpenId(), new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgStudents)) {
            consult = (TxConsultUser)consultUsers.get(0);
        }
        if (null != consult && consult.getIsConsulter() != null && consult.getIsConsulter().intValue() == Flag.FALSE.getInt()) {
            return consult.getName();
        }
        Fans fans = this.fansDao.getByOpenId(invitee.getInviterOpenId());
        return fans.getNick();
    }

    private String vzhiboEventProcess(QRCodeScene scene, WechatEventMessage message) {
        String openId = message.getFromUserName();
        TxVZhiBoInvitee invitee = this.txVZhiBoInviteeDao.getBySceneIdAndOpenId(scene.getId(), openId);
        if (null == invitee) {
            invitee = new TxVZhiBoInvitee();
            invitee.setSceneId(Integer.valueOf(scene.getId().intValue()));
            invitee.setInviterType(scene.getRoleType());
            invitee.setInviterId(scene.getRoleId());
            invitee.setInviterOpenId(scene.getRoleStr());
            invitee.setLessonId(scene.getBizId());
            invitee.setOpenId(openId);
            invitee.setCreateTime(new Date());
            invitee.setUpdateTime(invitee.getCreateTime());
            this.txVZhiBoInviteeDao.save((Object)invitee, new String[0]);
        }
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)invitee.getLessonId(), new String[0]);
        InviteCardTaskDto taskDto = new InviteCardTaskDto(Integer.valueOf(txVZhiBoLesson.getId().intValue()), openId, Boolean.valueOf(true));
        this.redisTemplate.opsForList().rightPush((Object)RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(), (Object)taskDto.toJson());
        String lessonName = txVZhiBoLesson.getName();
        String inviterName = this.getInviterName(txVZhiBoLesson.getOrgId(), invitee);
        String vzhiboLink = this.getLiveLessonUrl(txVZhiBoLesson.getOrgId(), txVZhiBoLesson.getId());
        if (StringUtils.isEmpty((CharSequence)vzhiboLink)) {
            return "";
        }
        String content = String.format(VZHIBO_QR_CODE_SCAN_RESP, inviterName, String.format(LINK_STR, vzhiboLink, lessonName));
        return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content);
    }
}

