/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.SalWechatErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatRemoteCallHelper {
    private static final Logger log = LoggerFactory.getLogger(WechatRemoteCallHelper.class);

    public static WechatApiResponse get(String url, boolean logResponse) throws WechatException, WebServiceException {
        try {
            String response = HttpClientUtils.doGet((String)url, null);
            if (logResponse) {
                log.info("WechatRemoteCallHelper - url:{}, response:{}", (Object)url, (Object)response);
            } else {
                log.info("WechatRemoteCallHelper - url:{}", (Object)url);
            }
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("WechatRemoteCallHelper - get - url:{}", (Object)url);
            log.warn("WechatRemoteCallHelper - get - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse get(String url) {
        return WechatRemoteCallHelper.get(url, true);
    }

    public static WechatApiResponse get(String url, Map<String, Object> params, boolean logResponse) throws WechatException, WebServiceException {
        try {
            if (params != null && !params.isEmpty()) {
                StringBuilder builder = new StringBuilder(url);
                if (!url.contains("?")) {
                    builder.append("?");
                }
                for (String key : params.keySet()) {
                    builder.append("&").append(key).append("=").append(params.get(key));
                }
                url = builder.toString();
            }
            String response = HttpClientUtils.doGet((String)url, null);
            if (logResponse) {
                log.info("WechatRemoteCallHelper - url:{}, response:{}", (Object)url, (Object)response);
            } else {
                log.info("WechatRemoteCallHelper - url:{}", (Object)url);
            }
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("WechatRemoteCallHelper - get - url:{}", (Object)url);
            log.warn("WechatRemoteCallHelper - get - exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse get(String url, Map<String, Object> params) {
        return WechatRemoteCallHelper.get(url, params, true);
    }

    public static WechatApiResponse postJson(String url, Map<String, Object> params, boolean logResponse) throws WechatException, WebServiceException {
        try {
            String response = WechatRemoteCallHelper.doPostJSON(url, JSONObject.fromObject(params).toString());
            log.info("WechatRemoteCallHelper - url:{}, params:{}, response:{}", new Object[]{url, params, response});
            if (logResponse) {
                log.info("WechatRemoteCallHelper - url:{}, params:{}, response:{}", new Object[]{url, params, response});
            } else {
                log.info("WechatRemoteCallHelper - url:{}, params:{}", (Object)url);
            }
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("WechatRemoteCallHelper - postJson - url:{}, params", (Object)url, params);
            log.warn("WechatRemoteCallHelper - postJson - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse postJson(String url, Map<String, Object> params) {
        return WechatRemoteCallHelper.postJson(url, params, true);
    }

    public static WechatApiResponse postJsonObj(String url, JSONObject json, boolean logResponse) throws WechatException, WebServiceException {
        try {
            String response = WechatRemoteCallHelper.doPostJSON(url, json.toString());
            if (logResponse) {
                log.info("WechatRemoteCallHelper - url:{}, params:{}, response:{}", new Object[]{url, json, response});
            } else {
                log.info("WechatRemoteCallHelper - url:{}, params:{}", (Object)url);
            }
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("WechatRemoteCallHelper - postJson - url:{}, params", (Object)url, (Object)json);
            log.warn("WechatRemoteCallHelper - postJson - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse postJsonObj(String url, JSONObject json) {
        return WechatRemoteCallHelper.postJsonObj(url, json, true);
    }

    public static WechatApiResponse postJsonStr(String url, String jsonStr, boolean logResponse) {
        String response = WechatRemoteCallHelper.doPostJSON(url, jsonStr);
        if (logResponse) {
            log.info("WechatRemoteCallHelper - url:{}, params:{}, response:{}", new Object[]{url, jsonStr, response});
        } else {
            log.info("WechatRemoteCallHelper - url:{}, params:{}", (Object)url);
        }
        return WechatRemoteCallHelper.convertJson(response);
    }

    public static WechatApiResponse postFile(String url, Map<String, String> params, File file) throws WechatException, WebServiceException {
        try {
            if (file == null) {
                throw new RuntimeException("postFile - file is null");
            }
            if (params == null) {
                params = new HashMap<String, String>();
            }
            HashMap<String, File> files = new HashMap<String, File>();
            files.put(file.getName(), file);
            String response = com.baijia.tianxiao.util.httpclient.HttpClientUtils.doPostFiles((String)url, params, files);
            log.info("request1 - url:{}, params:{}, fileName:{}, response:{}", new Object[]{url, params, file.getName(), response});
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("WechatRemoteCallHelper - postFile - url:{}, fileName:{}", (Object)url, (Object)file.getName());
            log.warn("WechatRemoteCallHelper - postFile - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse postWechatPermanentMedia(String urlStr, Map<String, String> params, File file, MediaType mediaType) {
        try {
            URL url = new URL(urlStr);
            String result = null;
            long filelength = file.length();
            String fileName = file.getName();
            String type = mediaType.getStr();
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Connection", "Keep-Alive");
            con.setRequestProperty("Charset", "UTF-8");
            String BOUNDARY = "----------" + System.currentTimeMillis();
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            StringBuilder sb = new StringBuilder();
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"type\" \r\n\r\n");
            sb.append(type + "\r\n");
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"description\" \r\n\r\n");
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"media\";filename=\"" + fileName + "\";filelength=\"" + filelength + "\" \r\n");
            sb.append("Content-Type:application/octet-stream\r\n\r\n");
            byte[] head = sb.toString().getBytes("utf-8");
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            ((OutputStream)out).write(head);
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                ((OutputStream)out).write(bufferOut, 0, bytes);
            }
            in.close();
            byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");
            ((OutputStream)out).write(foot);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            if (result == null) {
                result = buffer.toString();
            }
            return WechatRemoteCallHelper.convertJson(result);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("WechatRemoteCallHelper - postWechatPermanentMedia - url:{}, fileName:{}", (Object)urlStr, (Object)file.getName());
            log.warn("WechatRemoteCallHelper - postWechatPermanentMedia - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse convertJson(String jsonData) throws WechatException {
        int errorCode = 0;
        String errorMsg = "";
        if (StringUtils.isNotBlank((String)jsonData)) {
            JSONObject jsonObj = JSONObject.fromObject((Object)jsonData);
            errorCode = jsonObj.optInt("errcode", 0);
            errorMsg = jsonObj.optString("errmsg", "");
            if (errorCode != 0) {
                if (errorCode == -1) {
                    throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SYSTEM_ERROR);
                }
                if (errorCode == 40001 || errorCode == 40014 || errorCode == 42001) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID);
                }
                if (errorCode == 48001) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_PERMISSION_DENIED);
                }
                if (errorCode == 61007) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_AUTHORIZATION_DENIED);
                }
                if (errorCode == 45015) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_CANNOT_SENDMSG_TO_FANS);
                }
                if (errorCode == 40003) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_ILLEGAL_OPENID);
                }
                if (errorCode == 61003) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_WRONG_COMPONET);
                }
                if (errorCode == 61004) {
                    log.error("ERROR - WechatJsonConverter convertJson json:{}", (Object)jsonData);
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_API_RETURN_ERROR, "\u5fae\u4fe1\u63d0\u793a: " + errorMsg);
                }
                if (errorCode == WechatErrorCode.ec40037.getCode()) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_WRONG_TEMPLATE_ID);
                }
                if (errorCode == WechatErrorCode.ec45047.getCode()) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.MESSAGE_PUSH_TO_WECHAT_FAIL_45047);
                }
                if (errorCode == WechatErrorCode.ec61023.getCode()) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_REFRESH_TOKEN_IS_INVALID);
                }
                log.warn("ERROR - WechatJsonConverter convertJson json:{}", (Object)jsonData);
                WechatErrorCode wechatEC = WechatErrorCode.getByCode(errorCode);
                if (wechatEC != null) {
                    errorMsg = wechatEC.getMsg();
                }
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_API_RETURN_ERROR, "\u5fae\u4fe1\u63d0\u793a: " + errorMsg);
            }
        } else {
            log.warn("ERROR - WechatJsonConverter convertJson json:{}", (Object)jsonData);
            throw new WebServiceException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u7a7a\u503c");
        }
        return new WechatApiResponse(errorCode, errorMsg, jsonData);
    }

    private static String doPostJSON(String url, String jsonStr) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            StringEntity postEntity = new StringEntity(jsonStr, "utf-8");
            postEntity.setContentEncoding("utf-8");
            postEntity.setContentType("application/json");
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)postEntity);
            RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(15000).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

