/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatDataSyncLog;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.api.WechatDataSyncLogService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansDetailDto;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansListDto;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansListRecordDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.user.FansServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.task.FansSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FansServiceImpl
implements FansService {
    private static final Logger log = LoggerFactory.getLogger(FansServiceImpl.class);
    @Autowired
    private FansDao fansDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired(required=false)
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private WechatDataSyncLogService wechatDataSyncLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean redisFansSyncInterval(String appId) {
        String key = String.format(RedisKeyEnums.CRM.TX_WECHAT_FANS_INTERVAL_PRE.getRedisKey(), appId);
        Long intervalSeconds = 5L;
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB().intValue());
            if (connection.exists(key.getBytes()).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            connection.setEx(key.getBytes(), intervalSeconds.longValue(), "".getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Wechat - redisFansSyncInterval - exception - e:{}", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    @Override
    public boolean isNeedToSync(int orgId) {
        try {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
            if (this.wechatDataSyncLogService.hasTaskOngoing(authorizerInfo.getAuthorizerAppId(), WechatDataSyncType.FANS)) {
                log.info("wechat fans - isNeedToSync - RETURN FALSE - orgId:{}", (Object)orgId);
                return false;
            }
            if (!this.redisFansSyncInterval(authorizerInfo.getAuthorizerAppId())) {
                log.info("wechat fans - isNeedToSync - RETURN FALSE - orgId:{}", (Object)orgId);
                return false;
            }
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_LIST, true);
            int fansCount = this.fansDao.countSubscribe(authorizationInfo.getAuthorizerAppId());
            int wechatFansCount = FansServiceApiHelper.getFansCount(authorizationInfo.getAuthorizerAccessToken());
            if (fansCount != wechatFansCount) {
                log.info("wechat fans - isNeedToSync - RETURN TURE - orgId:{}, fansCount:{},wechatFansCount:{}", new Object[]{orgId, fansCount, wechatFansCount});
                return true;
            }
        }
        catch (BussinessException | WechatException e) {
            log.warn("wechat fans - isNeedToSync - orgId:{}, CustomException:{}", (Object)orgId, (Object)e);
        }
        catch (Exception e) {
            log.error("wechat fans - isNeedToSync - Exception - orgId:{}", (Object)orgId);
            log.error("wechat fans - isNeedToSync - Exception", (Throwable)e);
        }
        log.info("wechat fans - isNeedToSync - RETURN FALSE - orgId:{}", (Object)orgId);
        return false;
    }

    @Override
    public FansListDto listFans(Integer orgId, String searchText, PageDto pageDto) throws CustomException {
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_LIST);
        if (pageDto.getPageNum() == 1 && this.isNeedToSync(orgId)) {
            try {
                log.info("wechat - listFans - handle - add fansSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
                TaskHelper.getInstance().addTask(new FansSyncJob(this, authorizerInfo.getAuthorizerAppId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String authorizerAppId = authorizerInfo.getAuthorizerAppId();
        Integer count = this.fansDao.count(authorizerAppId);
        List fansList = null;
        fansList = count > 0 ? this.fansDao.search(authorizerAppId, searchText, pageDto) : new ArrayList();
        pageDto.setCurPageCount(Integer.valueOf(fansList.size()));
        pageDto.setCount(count);
        List<FansListRecordDto> recordList = FansListRecordDto.buildList(fansList);
        if (recordList != null && !recordList.isEmpty()) {
            ArrayList<String> openIdList = new ArrayList<String>();
            for (FansListRecordDto dto : recordList) {
                openIdList.add(dto.getOpenId());
            }
            Map keyOpenIdValueConsultUserIdMap = this.txConsultUserDao.mapKeyOpenIdValueId(orgId, openIdList);
            for (FansListRecordDto dto : recordList) {
                TxConsultUser user = (TxConsultUser)keyOpenIdValueConsultUserIdMap.get(dto.getOpenId());
                if (user != null) {
                    dto.setConsultUserId(user.getId());
                    dto.setUserRole(this.getUserRole(user));
                    continue;
                }
                dto.setUserRole(-1);
                dto.setConsultUserId(-1L);
            }
        }
        FansListDto dto = new FansListDto(recordList);
        return dto;
    }

    public int getUserRole(TxConsultUser user) {
        OrgStudent orgStudent;
        MsgUserRole userType = null;
        if (user.getStudentId() != null && user.getStudentId() > 0L) {
            userType = MsgUserRole.STUDENT;
        } else if (user.getUserId() != null && user.getUserId() > 0L && (orgStudent = this.orgStudentDao.getStudent(user.getOrgId(), user.getUserId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0])) != null) {
            userType = MsgUserRole.STUDENT;
        }
        if (userType == null) {
            userType = Flag.getBoolean((Integer)user.getIsConsulter()) ? MsgUserRole.CLUE : MsgUserRole.CONSULT;
        }
        return userType.getValue();
    }

    @Override
    @Transactional(readOnly=true)
    public FansDetailDto getFansDetail(String openId) {
        Fans fans = this.fansDao.getByOpenId(openId);
        return FansDetailDto.build(fans);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public void syncFansFullAmount(String authorizerAppId) throws CustomException {
        log.info("wechat - FansService - syncFansFullAmount - start - authorizerAppId:{}", (Object)authorizerAppId);
        int fansNum = 0;
        int failNum = 0;
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByAuthorizerAppId(authorizerAppId);
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizationInfo.getOrgId());
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        List<String> openIds = FansServiceApiHelper.getAllFansOpenIdList(accessToken);
        int openIdSize = openIds == null ? 0 : openIds.size();
        log.info("wechat - FansService - syncFans - start - openIds size:{}", (Object)openIdSize);
        if (openIds != null && !openIds.isEmpty()) {
            fansNum = openIds.size();
            ArrayList<String> tempOpendIds = new ArrayList<String>();
            for (int i = 0; i < openIds.size(); ++i) {
                tempOpendIds.add(openIds.get(i));
                if ((i == 0 || i % 100 != 0) && i != openIds.size() - 1) continue;
                Map openIdMap = this.fansDao.mapKeyOpenIdValueFans(tempOpendIds);
                ArrayList<Fans> fansList = new ArrayList<Fans>();
                Fans fans = null;
                for (String tempOpenId : tempOpendIds) {
                    try {
                        fans = FansServiceApiHelper.getFansInfo(accessToken, tempOpenId);
                    }
                    catch (WechatException e) {
                        if (e.getErrorCode() == SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID) {
                            accessToken = this.authorizationInfoService.forceRefreshAccessToken(authorizationInfo.getOrgId()).getAuthorizerAccessToken();
                            fans = FansServiceApiHelper.getFansInfo(accessToken, tempOpenId);
                        }
                        log.error("wechat - FansServiceImpl - syncFansFullAmount - getFansInfo WechatException(all fail) - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                        throw e;
                    }
                    catch (WebServiceException e) {
                        log.warn("wechat - FansServiceImpl - syncFansFullAmount - getFansInfo Exception - authorizerAppId:{},openId:{},e:{}", new Object[]{authorizerAppId, tempOpenId, e});
                        ++failNum;
                        continue;
                    }
                    catch (Exception e) {
                        log.error("wechat - FansServiceImpl - syncFansFullAmount - getFansInfo Exception - authorizerAppId:{},openId:{},e:{}", new Object[]{authorizerAppId, tempOpenId, e});
                        ++failNum;
                        continue;
                    }
                    if (fans == null) continue;
                    Fans dbFans = (Fans)openIdMap.get(tempOpenId);
                    if (dbFans == null) {
                        fans.initBasicAttribute();
                        fans.setAuthorizerAppId(authorizerAppId);
                        fans.setLastCommunicationTime(new Date(0L));
                        fansList.add(fans);
                        continue;
                    }
                    if (!(dbFans.getNick().equals(fans.getNick()) && dbFans.getHeadImgUrl().equals(fans.getHeadImgUrl()) && dbFans.getSubscribe().equals(fans.getSubscribe()))) {
                        fans.setId(dbFans.getId());
                        fans.setLastCommunicationTime(dbFans.getLastCommunicationTime());
                        fans.setSubscribe(Integer.valueOf(1));
                        fans.setUpdateTime(new Date());
                        this.fansDao.update((Object)fans, new String[0]);
                        continue;
                    }
                    Fans oldFans = this.fansDao.getByOpenId(tempOpenId);
                    if (oldFans.getSubscribe() != 0) continue;
                    oldFans.setSubscribe(Integer.valueOf(1));
                    oldFans.setUpdateTime(new Date());
                    this.fansDao.update((Object)oldFans, new String[0]);
                }
                try {
                    this.batchSaveFans(fansList);
                }
                catch (Exception e) {
                    log.warn("wechat - FansServiceImpl - fans batch insert fail", (Throwable)e);
                }
                tempOpendIds = new ArrayList();
            }
        }
        log.info("wechat - FansService - syncFansFullAmount - end - authorizerAppId:{}, fansNum:{}, failNum:{}", new Object[]{authorizerAppId, fansNum, failNum});
    }

    @Override
    public Integer syncFansIncrement(String authorizerAppId) throws CustomException {
        Date now;
        log.info("wechat - FansService - syncFansIncrement - start - authorizerAppId:{}", (Object)authorizerAppId);
        Date startTime = now = new Date();
        Integer amountExpected = 0;
        Integer amountCompleted = 0;
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerAppId);
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        HashSet<String> openIds = FansServiceApiHelper.getAllFansOpenIdHashSet(accessToken);
        this.batchUpdateFansToUnSubscribe(authorizerAppId, openIds, now);
        List openIdInDB = this.fansDao.listOpenIds(authorizerAppId);
        if (CollectionUtils.isNotEmpty((Collection)openIdInDB)) {
            for (String inDB : openIdInDB) {
                openIds.remove(inDB);
            }
        }
        if (openIds.size() == 0) {
            log.info("wechat - FansService - syncFansIncrement - return - authorizerAppId:{}", (Object)authorizerAppId);
            return 0;
        }
        if (this.wechatDataSyncLogService.hasTaskOngoing(authorizerAppId, WechatDataSyncType.FANS)) {
            log.info("wechat - FansService - syncFansIncrement - return - authorizerAppId:{}", (Object)authorizerAppId);
            return 0;
        }
        now = new Date();
        amountExpected = openIds.size();
        Date syncLogExpireTime = new Date(now.getTime() + (long)(amountExpected * 500));
        WechatDataSyncStatus syncLogEndStatus = WechatDataSyncStatus.END_SUCCESS;
        OrgWechatDataSyncLog syncLog = this.wechatDataSyncLogService.buildDefaultLog(authorizerAppId, WechatDataSyncType.FANS, startTime, amountExpected, syncLogExpireTime);
        try {
            Fans fans = null;
            ArrayList<Object> fansList = new ArrayList<Fans>();
            int i = 0;
            for (String tempOpenId : openIds) {
                try {
                    fans = FansServiceApiHelper.getFansInfo(accessToken, tempOpenId);
                }
                catch (WechatException e) {
                    if (e.getErrorCode() == SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID) {
                        accessToken = this.authorizationInfoService.forceRefreshAccessToken(authorizationInfo.getOrgId()).getAuthorizerAccessToken();
                        fans = FansServiceApiHelper.getFansInfo(accessToken, tempOpenId);
                    }
                    log.error("wechat - FansServiceImpl - syncFansIncrement - getFansInfo WechatException(all fail) - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                    throw e;
                }
                catch (WebServiceException e) {
                    log.warn("wechat - FansServiceImpl - syncFansIncrement - getFansInfo Exception - authorizerAppId:{},openId:{},e:{}", new Object[]{authorizerAppId, tempOpenId, e});
                    continue;
                }
                catch (Exception e) {
                    log.error("wechat - FansServiceImpl - syncFansIncrement - getFansInfo Exception - authorizerAppId:{},openId:{},e:{}", new Object[]{authorizerAppId, tempOpenId, e});
                    continue;
                }
                if (fans != null) {
                    fans.initBasicAttribute();
                    fans.setAuthorizerAppId(authorizerAppId);
                    fans.setLastCommunicationTime(new Date(0L));
                    fansList.add(fans);
                }
                if ((i != 0 && i % 100 == 0 || i == openIds.size() - 1) && CollectionUtils.isNotEmpty(fansList)) {
                    try {
                        this.batchSaveFans(fansList);
                        amountCompleted = amountCompleted + fansList.size();
                        now = new Date();
                        syncLog.setAmountCompleted(amountCompleted);
                        syncLog.setUpdateTime(now);
                        this.wechatDataSyncLogService.saveOrUpdateInNewTransaction(syncLog);
                    }
                    catch (Exception e) {
                        log.warn("wechat - syncFansIncrement - fans batch insert fail", (Throwable)e);
                    }
                    fansList = new ArrayList();
                }
                ++i;
            }
        }
        catch (Exception e) {
            syncLogEndStatus = WechatDataSyncStatus.END_FAIL;
            throw e;
        }
        finally {
            now = new Date();
            syncLog.setStatus(Integer.valueOf(syncLogEndStatus.getValue()));
            syncLog.setAmountCompleted(amountCompleted);
            syncLog.setStartTime(startTime);
            syncLog.setEndTime(now);
            syncLog.setUpdateTime(now);
            this.wechatDataSyncLogService.saveOrUpdateInNewTransaction(syncLog);
        }
        return amountCompleted;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remark(Integer orgId, String openId, String remark) {
        AuthorizationInfo authorizationInfo;
        if (remark == null) {
            remark = "";
        }
        if ((authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId)) == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        FansServiceApiHelper.remark(authorizationInfo.getAuthorizerAccessToken(), openId, remark);
        Fans fans = this.fansDao.getByOpenId(openId);
        fans.setRemark(remark);
        this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
        log.info("wechat - FansService - remark - orgId:{}, openId:{}, remark:{}", new Object[]{orgId, openId, remark});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateFans(Fans fans) {
        Fans oldFans = this.fansDao.getByOpenId(fans.getOpenId());
        if (oldFans == null) {
            fans.initBasicAttribute();
            this.fansDao.save((Object)fans, Boolean.valueOf(true), new String[0]);
            try {
                this.convertFansHeadImg(null, fans);
            }
            catch (Exception e) {
                log.warn("saveOrUpdateFans - convertFansHeadImg - exception:{}", (Throwable)e);
            }
        } else {
            oldFans.refreshBy(fans);
            this.fansDao.update((Object)fans, new String[0]);
            try {
                this.convertFansHeadImg(null, oldFans);
            }
            catch (Exception e) {
                log.warn("saveOrUpdateFans - convertFansHeadImg - exception:{}", (Throwable)e);
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Fans getFans(int orgId, String openId) {
        Fans fans = this.fansDao.getByOpenId(openId);
        if (fans == null) {
            return null;
        }
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizerInfo == null || !authorizerInfo.getAuthorizerAppId().equals(fans.getAuthorizerAppId())) {
            return null;
        }
        return fans;
    }

    @Override
    @Transactional(readOnly=true)
    public Fans getFans(String openId) {
        return this.fansDao.getByOpenId(openId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void batchSaveFans(List<Fans> fansList) {
        this.fansDao.saveAll(fansList, false, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public String convertFansHeadImg(Long orgId, Fans fans) {
        String headImgUrlGsx;
        block11: {
            if (!WechatProperties.getSwitchFansImgConvert()) {
                return "";
            }
            if (orgId == null) {
                orgId = 0L;
            }
            if (fans == null || StringUtils.isBlank((CharSequence)fans.getHeadImgUrl())) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)fans.getHeadImgUrlGsx())) {
                return fans.getHeadImgUrlGsx();
            }
            String wxHeadImgUrl = fans.getHeadImgUrl();
            headImgUrlGsx = null;
            File localFile = null;
            Date now = new Date();
            MIMEType mime = MIMEType.JPG;
            try {
                byte[] data = HttpClientUtils.download((String)wxHeadImgUrl);
                if (data != null) {
                    localFile = LocalFileHelper.saveToLocal(data, mime);
                    UploadResult result = FileUploadUtils.uploadToRemote(orgId, localFile, false);
                    UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)result.getFiles().get(0);
                    this.saveToDb(uploadFile, mime);
                    headImgUrlGsx = StorageUtil.constructUrl(uploadFile.getFid(), uploadFile.getSn(), mime.getCode());
                    fans.setHeadImgUrlGsx(headImgUrlGsx);
                    fans.setUpdateTime(now);
                    this.fansDao.update((Object)fans, new String[0]);
                    this.txConsultUserDao.replacePortrait(wxHeadImgUrl, headImgUrlGsx);
                } else {
                    log.warn("wechat - fans convertFansHeadImg - download wechat img error");
                }
                if (localFile == null) break block11;
            }
            catch (Exception e) {
                block12: {
                    try {
                        log.error("wechat - fans convertFansHeadImg - exception", (Throwable)e);
                        if (localFile == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (localFile != null) {
                            LocalFileHelper.deleteFile(localFile);
                        }
                        log.info("convertFansHeadImg fansId:{}, headImg:{}", (Object)fans.getId(), headImgUrlGsx);
                        throw throwable;
                    }
                    LocalFileHelper.deleteFile(localFile);
                }
                log.info("convertFansHeadImg fansId:{}, headImg:{}", (Object)fans.getId(), headImgUrlGsx);
            }
            LocalFileHelper.deleteFile(localFile);
        }
        log.info("convertFansHeadImg fansId:{}, headImg:{}", (Object)fans.getId(), headImgUrlGsx);
        return headImgUrlGsx;
    }

    private Integer saveToDb(UploadResult.UploadFile uploadFile, MIMEType mimeType) {
        OrgStorage orgStorage = new OrgStorage();
        orgStorage.setFid(uploadFile.getFid());
        orgStorage.setSn(uploadFile.getSn());
        orgStorage.setSize(Integer.valueOf(uploadFile.getSize()));
        orgStorage.setMimeType(Integer.valueOf(mimeType.getCode()));
        Date now = new Date();
        orgStorage.setCreateTime(now);
        orgStorage.setUpdateTime(now);
        orgStorage.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStorage.setSource(Short.valueOf((short)0));
        this.orgStorageDao.save((Object)orgStorage, Boolean.valueOf(true), new String[0]);
        return orgStorage.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchConvertFansHeadImg(String authorizerAppId) {
        Integer pageNum = 1;
        PageDto dto = new PageDto();
        dto.setPageSize(Integer.valueOf(500));
        dto.setPageNum(pageNum);
        List fansList = this.fansDao.listFansWhichGxsImgIsNull(authorizerAppId, dto);
        while (CollectionUtils.isNotEmpty((Collection)fansList)) {
            AuthorizationInfo authorizationInfo;
            Long orgId = 0L;
            if (StringUtils.isNotBlank((CharSequence)authorizerAppId) && (authorizationInfo = this.authorizationInfoService.getByAuthorizerAppId(authorizerAppId)) != null) {
                orgId = authorizationInfo.getOrgId().longValue();
            }
            log.info("batchConvertFansHeadImg - start - fans size:{}", (Object)fansList.size());
            for (Fans fans : fansList) {
                try {
                    String string = this.convertFansHeadImg(orgId, fans);
                }
                catch (Exception e) {
                    log.warn("batchConvertFansHeadImg - exception", (Throwable)e);
                }
            }
            pageNum = pageNum + 1;
            dto.setPageNum(pageNum);
            fansList = this.fansDao.listFansWhichGxsImgIsNull(authorizerAppId, dto);
        }
        log.info("batchConvertFansHeadImg - end - fans size:{}", (Object)fansList.size());
    }

    @Override
    public void updateFansInfo(String openId) {
        Fans fansInDB = this.fansDao.getByOpenId(openId);
        if (fansInDB != null) {
            try {
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(fansInDB.getAuthorizerAppId());
                String accessToken = authorizationInfo.getAuthorizerAccessToken();
                Fans fansInWechat = FansServiceApiHelper.getFansInfo(accessToken, fansInDB.getOpenId());
                if (!(fansInDB.getNick().equals(fansInWechat.getNick()) && fansInDB.getHeadImgUrl().equals(fansInWechat.getHeadImgUrl()) && fansInDB.getSubscribe().equals(fansInWechat.getSubscribe()))) {
                    fansInWechat.setId(fansInDB.getId());
                    fansInWechat.setLastCommunicationTime(fansInDB.getLastCommunicationTime());
                    fansInWechat.setUpdateTime(new Date());
                    this.fansDao.update((Object)fansInWechat, new String[0]);
                }
            }
            catch (Exception e) {
                log.warn("wechat - updateFansInfo - fail - openId:{}, e:{}", (Object)openId, (Object)e);
            }
        }
    }

    @Override
    @Transactional
    public void batchUpdateFansToUnSubscribe(String authorizerAppId, HashSet<String> openIds, Date now) {
        this.fansDao.batchUpdateFansToUnSubscribe(authorizerAppId, openIds, now);
    }
}

