/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.menu;

import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuBtnType;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.MenuConvertResult;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.menu.Button;
import com.baijia.tianxiao.sal.wechat.dto.menu.ClickButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.ComplexButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.MediaButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.Menu;
import com.baijia.tianxiao.sal.wechat.dto.menu.ViewButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.ViewLimitedButton;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuBtnBuilder;
import com.baijia.tianxiao.sal.wechat.util.RandomUtil;
import com.baijia.tianxiao.sal.wechat.validator.CustomMenuValidator;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatMenuJsonConverter {
    private static final Logger log = LoggerFactory.getLogger(WechatMenuJsonConverter.class);

    public static MenuConvertResult customJsonToWechatMenuJson(OrgWechatDto orgWechatDto, String menuJsonStr) {
        if (StringUtils.isBlank((CharSequence)menuJsonStr) || menuJsonStr.equals("{}")) {
            return new MenuConvertResult(menuJsonStr, null);
        }
        JSONObject wechatMenuJson = new JSONObject();
        JSONArray wechatBtnArray = new JSONArray();
        log.info("menus is :{} ", (Object)menuJsonStr);
        JSONObject menuJson = JSONObject.fromObject((Object)menuJsonStr);
        log.info("menusJson is :{} ", (Object)menuJsonStr);
        JSONArray btnArray = menuJson.optJSONArray("list");
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(menuJsonStr, null);
        }
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject wechatBtn = null;
                JSONObject btn = btnArray.getJSONObject(i);
                try {
                    if (btn.optString("mediaType", "").equals("") && btn.get("subButton") != null && !btn.get("subButton").equals("null") && btn.getJSONArray("subButton").size() == 0) {
                        throw new ParameterException("\u6309\u94ae " + btn.getString("name") + " \u683c\u5f0f\u4e0d\u5408\u6cd5.");
                    }
                }
                catch (Exception e) {
                    throw new ParameterException("\u6309\u94ae " + btn.getString("name") + " \u683c\u5f0f\u4e0d\u5408\u6cd5.");
                }
                if (btn.get("subButton") == null || btn.get("subButton").equals("null") || btn.getJSONArray("subButton").size() == 0) {
                    CustomMenuValidator._4ButtonName(btn.getString("name"));
                    wechatBtn = WechatMenuJsonConverter.btnToWechatBtn(orgWechatDto, btn);
                } else {
                    wechatBtn = new JSONObject();
                    wechatBtn.put((Object)"name", (Object)btn.getString("name"));
                    wechatBtn.put((Object)"sub_button", (Object)WechatMenuJsonConverter.subBtnToWechatSubBtn(orgWechatDto, btn.getJSONArray("subButton")));
                    btn.remove("mediaType");
                    btn.remove("mediaId");
                    btn.remove("content");
                    btn.remove("url");
                }
                wechatBtnArray.add((Object)wechatBtn);
            }
        }
        log.info("wechatBtnArray is :{} ", (Object)wechatBtnArray);
        wechatMenuJson.put((Object)"button", (Object)wechatBtnArray);
        return new MenuConvertResult(menuJson.toString(), wechatMenuJson.toString());
    }

    private static JSONArray subBtnToWechatSubBtn(OrgWechatDto orgWechatDto, JSONArray subBtnArray) {
        JSONArray wechatSubBtnArray = new JSONArray();
        if (subBtnArray != null && !subBtnArray.isEmpty()) {
            for (int i = 0; i < subBtnArray.size(); ++i) {
                CustomMenuValidator._4SubButtonName(subBtnArray.getJSONObject(i).getString("name"));
                JSONObject wechatSubBtn = WechatMenuJsonConverter.btnToWechatBtn(orgWechatDto, subBtnArray.getJSONObject(i));
                if (wechatSubBtn == null) continue;
                wechatSubBtnArray.add((Object)wechatSubBtn);
            }
        }
        return wechatSubBtnArray;
    }

    private static JSONObject btnToWechatBtn(OrgWechatDto orgWechatDto, JSONObject btn) {
        JSONObject wechatBtn = null;
        MediaType type = MediaType.getByVaule(btn.getInt("mediaType"));
        if (MediaType.UNKNOWN == type) {
            return null;
        }
        String name = btn.optString("name", "");
        String mediaId = btn.optString("mediaId", "");
        Object urlObj = btn.get("url");
        String url = "";
        if (urlObj != null && !(urlObj instanceof JSONNull)) {
            url = urlObj.toString();
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            url = type.getUrl(orgWechatDto);
        }
        boolean isContent = false;
        isContent = WechatMenuJsonConverter.isContentForUnifiedWechatAccount(type, orgWechatDto, url);
        if (StringUtils.isBlank((CharSequence)name)) {
            name = type.getLabel();
        }
        if (MediaType.IMAGE == type) {
            wechatBtn = WechatMenuBtnBuilder.mediaBtn(name, mediaId);
        } else if (MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type) {
            if (MediaType.NEWS == type) {
                wechatBtn = WechatMenuBtnBuilder.mediaBtn(name, mediaId);
            } else if (isContent) {
                log.debug("btn is clickType btn :{} ", (Object)btn);
                String key = RandomUtil.str(10);
                wechatBtn = WechatMenuBtnBuilder.clickBtn(name, key);
                if (btn.containsKey((Object)"content")) {
                    wechatBtn.put((Object)"content", btn.get("content"));
                }
                btn.put((Object)"clickKey", (Object)key);
            } else {
                log.debug("btn is :{} ", (Object)btn);
                if (StringUtils.isBlank((CharSequence)url)) {
                    throw new ParameterException("\u64cd\u4f5c\u5931\u8d25, \u6309\u94ae \u2018" + name + "\u2019 \u672a\u8bbe\u7f6e\u8bbf\u95ee\u5730\u5740\u3002");
                }
                if (!url.startsWith("http") && !url.startsWith("https")) {
                    url = "http://" + url;
                }
                wechatBtn = WechatMenuBtnBuilder.viewBtn(name, url);
                btn.put((Object)"url", (Object)wechatBtn.getString("url"));
            }
        }
        return wechatBtn;
    }

    private static boolean isContentForUnifiedWechatAccount(MediaType type, OrgWechatDto orgWechatDto, String url) {
        boolean isContent = false;
        if (WechatMenuJsonConverter.isContent(type.getValue())) {
            if (orgWechatDto.isUnifiedWechatAccount() && GenericsUtils.notNullAndEmpty((Object)url)) {
                isContent = false;
            } else if (GenericsUtils.isNullOrEmpty((Object)url)) {
                isContent = true;
            }
        }
        return isContent;
    }

    private static boolean isContentForUnifiedWechatAccount(MediaType type, String url) {
        boolean isContent = false;
        if (WechatMenuJsonConverter.isContent(type.getValue())) {
            if (!type.isCanSetToUnifiedWechat()) {
                isContent = true;
            } else if (GenericsUtils.isNullOrEmpty((Object)url)) {
                isContent = true;
            }
        }
        return isContent;
    }

    public static Map<String, String> mapClickKeyVsContent(String menuJsonStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        JSONObject menuJson = JSONObject.fromObject((Object)menuJsonStr);
        JSONArray btnArray = menuJson.optJSONArray("list");
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject btn = btnArray.getJSONObject(i);
                int type = btn.optInt("mediaType", -1);
                if (type == -1) {
                    JSONArray subBtnArray = btn.getJSONArray("subButton");
                    if (subBtnArray == null || subBtnArray.isEmpty()) continue;
                    for (int j = 0; j < subBtnArray.size(); ++j) {
                        btn = subBtnArray.getJSONObject(j);
                        Object urlObj = btn.get("url");
                        String url = "";
                        if (urlObj != null && !(urlObj instanceof JSONNull)) {
                            url = urlObj.toString();
                        }
                        MediaType typeMenu = MediaType.getByVaule(btn.getInt("mediaType"));
                        log.info("btn is :{} ", (Object)btn);
                        if (typeMenu == null || !WechatMenuJsonConverter.isContentForUnifiedWechatAccount(typeMenu, url)) continue;
                        map.put(btn.getString("clickKey"), btn.optString("content"));
                    }
                    continue;
                }
                if (!WechatMenuJsonConverter.isContent(type)) continue;
                map.put(btn.getString("clickKey"), btn.optString("content"));
            }
        }
        return map;
    }

    private static boolean isContent(int mtype) {
        return mtype == MediaType.CONTENT.getValue() || mtype == MediaType.DIANHUA.getValue() || mtype == MediaType.ZAIXIANZIXUN.getValue();
    }

    public static MenuConvertResult wechatMenuJsonToCustomJson(String wechatMenuJsonStr) {
        if (StringUtils.isBlank((CharSequence)wechatMenuJsonStr) || wechatMenuJsonStr.equals("{}")) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }
        JSONObject customMenuJson = new JSONObject();
        JSONArray customBtnArray = new JSONArray();
        JSONObject wechatMenuJson = JSONObject.fromObject((Object)wechatMenuJsonStr);
        JSONArray btnArray = wechatMenuJson.getJSONObject("menu").optJSONArray("button");
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject customBtn = null;
                JSONObject wechatBtn = btnArray.getJSONObject(i);
                if (wechatBtn.get("sub_button") == null || wechatBtn.get("sub_button").equals("null") || wechatBtn.getJSONArray("sub_button").size() == 0) {
                    if (wechatBtn.get("type").equals(WechatMenuBtnType.VIEW.getValue())) {
                        customBtn = new JSONObject();
                        customBtn.put((Object)"mediaType", (Object)WechatMenuJsonConverter.getZIDINGYILiANJIETYPE(wechatBtn.getString("name")));
                        customBtn.put((Object)"name", wechatBtn.get("name"));
                        customBtn.put((Object)"note", (Object)("[" + wechatBtn.get("name") + "]"));
                        customBtn.put((Object)"url", wechatBtn.get("url"));
                    }
                } else {
                    JSONArray cutomSubBtnArray = null;
                    JSONArray wechatSubBtnArray = wechatBtn.getJSONArray("sub_button");
                    if (wechatSubBtnArray != null && !wechatSubBtnArray.isEmpty()) {
                        for (int j = 0; j < wechatSubBtnArray.size(); ++j) {
                            JSONObject wechatSubBtn = wechatSubBtnArray.getJSONObject(j);
                            if (!wechatSubBtn.get("type").equals(WechatMenuBtnType.VIEW.getValue())) continue;
                            JSONObject customSubBtn = new JSONObject();
                            customSubBtn.put((Object)"mediaType", (Object)WechatMenuJsonConverter.getZIDINGYILiANJIETYPE(wechatSubBtn.getString("name")));
                            customSubBtn.put((Object)"name", wechatSubBtn.get("name"));
                            customSubBtn.put((Object)"note", (Object)("[" + wechatSubBtn.get("name") + "]"));
                            customSubBtn.put((Object)"url", wechatSubBtn.get("url"));
                            if (customSubBtn == null) continue;
                            if (customBtn == null) {
                                customBtn = new JSONObject();
                                cutomSubBtnArray = new JSONArray();
                            }
                            cutomSubBtnArray.add((Object)customSubBtn);
                        }
                    }
                    if (customBtn != null) {
                        customBtn.put((Object)"name", (Object)wechatBtn.getString("name"));
                        customBtn.put((Object)"note", (Object)("[" + wechatBtn.getString("name") + "]"));
                        customBtn.put((Object)"subButton", cutomSubBtnArray);
                    }
                }
                if (customBtn == null) continue;
                customBtnArray.add((Object)customBtn);
            }
        }
        customMenuJson.put((Object)"list", (Object)customBtnArray);
        return new MenuConvertResult(customMenuJson.toString(), wechatMenuJson.toString());
    }

    public static int getZIDINGYILiANJIETYPE(String name) {
        MediaType type = MediaType.getByLabel(name);
        if (type != null) {
            return type.getValue();
        }
        return MediaType.ZIDINGYILIANJIE.getValue();
    }

    public static void main(String[] args) {
    }

    public static MenuConvertResult checkChange(String wechatMenuJsonStr, String dbJson) {
        if (StringUtils.isBlank((CharSequence)wechatMenuJsonStr) || wechatMenuJsonStr.equals("{}")) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }
        JSONObject customMenuJson = new JSONObject();
        JSONArray customBtnArray = new JSONArray();
        JSONObject wechatMenuJson = JSONObject.fromObject((Object)wechatMenuJsonStr);
        JSONArray btnArray = wechatMenuJson.getJSONObject("menu").optJSONArray("button");
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject customBtn = null;
                JSONObject wechatBtn = btnArray.getJSONObject(i);
                if (wechatBtn.get("sub_button") == null || wechatBtn.get("sub_button").equals("null") || wechatBtn.getJSONArray("sub_button").size() == 0) {
                    if (wechatBtn.get("type").equals(WechatMenuBtnType.VIEW.getValue())) {
                        customBtn = new JSONObject();
                        customBtn.put((Object)"mediaType", (Object)WechatMenuJsonConverter.getZIDINGYILiANJIETYPE(wechatBtn.getString("name")));
                        customBtn.put((Object)"name", wechatBtn.get("name"));
                        customBtn.put((Object)"note", (Object)("[" + wechatBtn.get("name") + "]"));
                        customBtn.put((Object)"url", wechatBtn.get("url"));
                        if (!dbJson.contains(wechatBtn.getString("name"))) {
                            return null;
                        }
                    } else if (MediaType.getByLabel(wechatBtn.getString("name")) == null) {
                        return null;
                    }
                } else {
                    JSONArray cutomSubBtnArray = null;
                    JSONArray wechatSubBtnArray = wechatBtn.getJSONArray("sub_button");
                    if (wechatSubBtnArray != null && !wechatSubBtnArray.isEmpty()) {
                        for (int j = 0; j < wechatSubBtnArray.size(); ++j) {
                            JSONObject wechatSubBtn = wechatSubBtnArray.getJSONObject(j);
                            if (wechatSubBtn.get("type").equals(WechatMenuBtnType.VIEW.getValue())) {
                                JSONObject customSubBtn = new JSONObject();
                                customSubBtn.put((Object)"mediaType", (Object)WechatMenuJsonConverter.getZIDINGYILiANJIETYPE(wechatSubBtn.getString("name")));
                                customSubBtn.put((Object)"name", wechatSubBtn.get("name"));
                                customSubBtn.put((Object)"note", (Object)("[" + wechatSubBtn.get("name") + "]"));
                                customSubBtn.put((Object)"url", wechatSubBtn.get("url"));
                                if (customSubBtn != null) {
                                    if (customBtn == null) {
                                        customBtn = new JSONObject();
                                        cutomSubBtnArray = new JSONArray();
                                    }
                                    cutomSubBtnArray.add((Object)customSubBtn);
                                }
                                if (dbJson.contains(wechatSubBtn.getString("name"))) continue;
                                return null;
                            }
                            if (MediaType.getByLabel(wechatSubBtn.getString("name")) != null) continue;
                            return null;
                        }
                    }
                    if (customBtn != null) {
                        if (!dbJson.contains(wechatBtn.getString("name"))) {
                            return null;
                        }
                        customBtn.put((Object)"name", (Object)wechatBtn.getString("name"));
                        customBtn.put((Object)"note", (Object)("[" + wechatBtn.getString("name") + "]"));
                        customBtn.put((Object)"subButton", cutomSubBtnArray);
                    }
                }
                if (customBtn == null) continue;
                customBtnArray.add((Object)customBtn);
            }
        }
        customMenuJson.put((Object)"list", (Object)customBtnArray);
        return new MenuConvertResult(customMenuJson.toString(), wechatMenuJson.toString());
    }

    public static MenuConvertResult wechatMenuJsonToCustomJson(Menu menu) {
        if (menu == null) {
            return new MenuConvertResult(null, null);
        }
        List<Button> buttons = menu.getButton();
        if (GenericsUtils.isNullOrEmpty(buttons)) {
            return new MenuConvertResult(null, null);
        }
        JSONObject customMenuJson = new JSONObject();
        JSONArray customBtnArray = new JSONArray();
        for (int i = 0; i < buttons.size(); ++i) {
            Button button = buttons.get(i);
            JSON retJsonObj = WechatMenuJsonConverter.solveButton(button);
            customBtnArray.add((Object)retJsonObj);
        }
        log.info("customBtnArray is :{} ", (Object)customBtnArray.toString());
        customMenuJson.put((Object)"list", (Object)customBtnArray);
        return new MenuConvertResult(customMenuJson.toString(), menu.toString());
    }

    private static JSON solveButton(Button button) {
        String name = button.getName();
        String note = WechatMenuJsonConverter.checkForNumStart(name);
        JSONObject customBtn = null;
        HashMap<String, Object> strMap = new HashMap<String, Object>();
        strMap.put("note", note);
        strMap.put("name", name);
        if (button instanceof ViewButton) {
            ViewButton tempButton = (ViewButton)button;
            strMap.put("mediaType", WechatMenuJsonConverter.getZIDINGYILiANJIETYPE(name));
            strMap.put("url", tempButton.getUrl());
        } else if (button instanceof ClickButton) {
            ClickButton tempButton = (ClickButton)button;
            strMap.put("mediaType", MediaType.CONTENT.getValue());
            strMap.put("content", tempButton.getContent());
            strMap.put("clickKey", tempButton.getKey());
        } else if (button instanceof ViewLimitedButton) {
            ViewLimitedButton vb = (ViewLimitedButton)button;
            strMap.put("mediaType", MediaType.NEWS.getValue());
            strMap.put("mediaId", vb.getMedia_id());
        } else if (button instanceof MediaButton) {
            MediaButton vb = (MediaButton)button;
            strMap.put("mediaType", MediaType.IMAGE.getValue());
            strMap.put("mediaId", vb.getMedia_id());
        } else if (button instanceof ComplexButton) {
            JSONArray cutomSubBtnArray = new JSONArray();
            ComplexButton tempButton = (ComplexButton)button;
            for (Button btn : tempButton.getSub_button()) {
                JSON solveButton = WechatMenuJsonConverter.solveButton(btn);
                cutomSubBtnArray.add((Object)solveButton);
            }
            strMap.put("subButton", cutomSubBtnArray);
        }
        customBtn = JSONObject.fromObject(strMap);
        log.info("customBtn :{} , button:{} ", (Object)customBtn, (Object)button);
        return customBtn;
    }

    private static String checkForNumStart(String name) {
        String regex = "\\d";
        String firstCharStr = String.valueOf(name.charAt(0));
        boolean matches = Pattern.matches(regex, firstCharStr);
        if (matches) {
            return "[_" + name + "]";
        }
        return "[" + name + "]";
    }
}

