package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

/**
 * @author Rezar
 * @createDate :Jun 30, 2016 3:07:44 PM
 * @desc :
 */
@Slf4j
public class JSSDKUtils {

    // 获取jsapi_ticket
    public static String jsapi_ticket_url =
        "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";

    /**
     * 获取jsapi_ticket
     * 
     * @param accessToken
     * @return
     */
    public static TwoTuple<String,Integer> trievalJsApiTicket(String accessToken) {
        int resultCode = 0;
        String jsApiTicket = null;
        Integer expiredTime = null;
        // 拼装创建Url
        String url = jsapi_ticket_url.replace("ACCESS_TOKEN", accessToken);
        // 调用接口获取jsapi_ticket
        JSONObject jsonObject = doGetRequest(url, null);
        // 如果请求成功
        if (null != jsonObject) {
            try {
                jsApiTicket = jsonObject.getString("ticket");
                expiredTime = jsonObject.getInt("expires_in");
                log.info("[JSSDKUtil] jsApiTicket param:{}", jsApiTicket);
            } catch (JSONException e) {
                if (0 != jsonObject.getInt("errcode")) {
                    resultCode = jsonObject.getInt("errcode");
                    log.error("JSAPI_Ticket获取失败 errcode:{} errmsg:{}", resultCode, jsonObject.getString("errmsg"));
                }
            }
        }
        return TupleUtil.tuple(jsApiTicket, expiredTime);
    }

    /**
     * 发送doGet请求
     * 
     * @param url
     * @param param
     * @return
     */
    private static JSONObject doGetRequest(String url, HashMap<String, String> param) {
        String doGet = HttpClientUtils.doGet(url, param);
        if (GenericsUtils.isNullOrEmpty(doGet)) {
            return null;
        }
        return JSONObject.fromObject(doGet);
    }

    /**
     * sha1加密
     * 
     * @param str
     * @return
     */
    public static String sha1Encrypt(String str) {
        String signature = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(str.getBytes("UTF-8"));
            signature = byteToHex(crypt.digest());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }

    private static String byteToHex(final byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

}
