/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.menu;

import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuBtnType;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuJsonKey;
import net.sf.json.JSONObject;

/**   
 * @title       : WechatMenuBtnBuilder 
 * @description : 微信自定义菜单按钮
 * @author      : zhenyujian
 * @date        : 2016年1月8日 下午8:23:00 
 */
public class WechatMenuBtnBuilder {
	

	/**
	 * @Description  : 链接跳转按钮
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月8日 下午8:38:30 
	 *
	 * @Return       : JSONObject
	 */
	public static JSONObject viewBtn(String name, String url){
		JSONObject btn = new JSONObject();
		btn.put(WechatMenuJsonKey.TYPE, WechatMenuBtnType.VIEW.getValue());
		btn.put(WechatMenuJsonKey.NAME, name);
		btn.put(WechatMenuJsonKey.URL, url);
		return btn;
	}
	
	
	
	/**
	 * @Description  : 点击事件按钮
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月8日 下午8:38:22 
	 *
	 * @Return       : JSONObject
	 */
	public static JSONObject clickBtn(String name, String key){
		JSONObject btn = new JSONObject();
		btn.put(WechatMenuJsonKey.TYPE, WechatMenuBtnType.CLICK.getValue());
		btn.put(WechatMenuJsonKey.NAME, name);
		btn.put(WechatMenuJsonKey.CLICK_KEY, key);
		return btn;
	}
	
	
	
	/**
	 * @Description  : 素材按钮
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月8日 下午8:38:18 
	 *
	 * @Return       : JSONObject
	 */
	public static JSONObject mediaBtn(String name, String mediaId){
		JSONObject btn = new JSONObject();
		btn.put(WechatMenuJsonKey.TYPE, WechatMenuBtnType.MEDIA_ID.getValue());
		btn.put(WechatMenuJsonKey.NAME, name);
		btn.put(WechatMenuJsonKey.MEDIA_ID, mediaId);
		return btn;
	}
	
	
	
	/**
	 * @Description  : 图文素材按钮
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月8日 下午8:38:06 
	 *
	 * @Return       : JSONObject
	 */
	public static JSONObject viewLimitedBtn(String name, String mediaId){
		JSONObject btn = new JSONObject();
		btn.put(WechatMenuJsonKey.TYPE, WechatMenuBtnType.VIEW_LIMITED.getValue());
		btn.put(WechatMenuJsonKey.NAME, name);
		btn.put(WechatMenuJsonKey.MEDIA_ID, mediaId);
		return btn;
	}
	
	
	
//	/**
//	 * @Description  : 内置链接类型按钮
//	 * @Author       : zhenyujian
//	 * @Date         : 2016年1月8日 下午9:16:01 
//	 *
//	 * @Return       : JSONObject
//	 */
//	public static JSONObject mediaTypeLinks(MediaType mediaType, String appId, String name, String url){
//		if(!StringUtils.isNotBlank(name)){
//			name = mediaType.getLabel();
//		}
//		
//		switch(mediaType){
//			case WANGXIAOZHUYE:
//				return viewBtn(name, url);
//				
//			case KECHENGDANYE:
//				return viewBtn(name, url);
//				
//			case HUODONG:
//				return viewBtn(name, url);
//				
//			case KECHENGLIEBIAO:
//				return viewBtn(name, url);
//				
//			case ZIDINGYILIANJIE:
//				return viewBtn(name, url);
//				
//			case WODEKEBIAO:
//				return viewBtn(name, WechatWebAuthLinkBuilder.schedule(WebAuthScope.BASE, appId));
//				
//			case WODEQIANDAO:
//				return viewBtn(name, WechatWebAuthLinkBuilder.mySigninRecord(WebAuthScope.BASE, appId));
//				
//			case WODEPINGJIA:
//				return viewBtn(name, WechatWebAuthLinkBuilder.rating(WebAuthScope.BASE, appId));
//				
//			case GERENZHONGXIN:
//				return viewBtn(name, WechatWebAuthLinkBuilder.personalCenter(WebAuthScope.BASE, appId));
//			default :
//				return null;
//		}
//	}
//	
//	
//	public static JSONObject mediaTypeLinks(MediaType mediaType, String appId, String url){
//		return mediaTypeLinks(mediaType, appId, null, url);
//	}
//	
//	public static JSONObject mediaTypeLinks(MediaType mediaType, String appId){
//		return mediaTypeLinks(mediaType, appId, null, null);
//	}
	
}

