/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.courseplan;

import java.text.SimpleDateFormat;
import java.util.Date;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;
import net.sf.json.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**   
 * @title       : CoursePlanStuMsg 
 * @description : 课表提醒 - 学生
 * @author      : zhenyujian
 * @date        : 2016年1月5日 下午9:04:52 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class CoursePlanMsgToStu extends WechatTemplateMsg{
	
	private Integer orgId;
	private String openId;
	
	private String orgName;
	private String courseName;
	private String studentName;
	private String teacherName;//课程上的老师（最多4个、其余用…表示），如果没有显示—
	private Long startTime;//课程开始日期 毫秒级 非必填
	private Long endTime;//课程结束日期 毫秒级 非必填
	private String orgMobile;//机构电话

	
	public CoursePlanMsgToStu(){
		this.msgType = WechateTemplateMsgType.COURSE_PLAN_TO_STU;
	}
	
	
	/**
	 * @Description  : 创建微信模板消息 用于调用微信api
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:50:29 
	 *
	 * @Return       : String
	 */
	public String buildTemplateMsg(String templateId){
		String firstFmt = "【%s】,您好:\n\n您在【%s】的【%s】已经完成课程安排。\n";
		this.first = String.format(firstFmt, studentName, orgName, courseName);
		this.remark = "\n点击查看课表。";
		
		JSONObject data = new JSONObject();

		data.put("keyword1", getTemplateMsgNode( studentName ) );
		
		if(startTime!=null && endTime!=null){
			SimpleDateFormat daySdf  = new SimpleDateFormat("yyyy-MM-dd");
			SimpleDateFormat timeSdf = new SimpleDateFormat("hh:mm");
			data.put("keyword2", getTemplateMsgNode( String.format("%s %s - %s", 
																	daySdf.format(new Date(startTime)),
																	timeSdf.format(new Date(endTime)),
																	timeSdf.format(new Date(endTime))) ) );
		}else{
			data.put("keyword2", getTemplateMsgNode( "-" ) );
		}
		data.put("keyword3", getTemplateMsgNode( courseName ) );
		
		
		data.put("keyword4", getTemplateMsgNode( teacherName!=null ? teacherName:"-" ) );
		data.put("keyword5", getTemplateMsgNode( "如有疑问,请联系机构:"+orgMobile ));
		
		return super.buildBaseTemplateMsg(openId, templateId, data).toString();
	}
	
	
	/**
	 * @Description  : json转换成对象
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:28:02 
	 *
	 * @Return       : CoursePlanMsg
	 */
	public static CoursePlanMsgToStu fromJsonStr(String jsonStr){
		CoursePlanMsgToStu msg = new CoursePlanMsgToStu();
		JSONObject json = JSONObject.fromObject(jsonStr);
		msg.fillBaseInfo(jsonStr);
		
		msg.setOrgId( json.optInt("orgId") );
		msg.setOpenId( json.optString("openId") );
		
		msg.setOrgName( json.optString("orgName") );
		msg.setCourseName( json.optString("courseName") );
		msg.setStudentName( json.optString("studentName") );
		msg.setTeacherName( json.optString("teacherName") );
		msg.setStartTime( json.optLong("startTime") );
		msg.setEndTime( json.optLong("endTime"));
		msg.setOrgMobile( json.optString("orgMobile") );
		
		return msg;
	}
	
	
	/**
	 * @Description  : 对象转换成json
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:28:12 
	 *
	 * @Return       : String
	 */
	public String toJsonStr(){
		JSONObject json = super.getBaseJson();
		json.put("orgId", checkNull(this.orgId) );
		json.put("openId", checkNull(this.openId) );

		json.put("orgName", checkNull(this.orgName));
		json.put("courseName", checkNull(this.courseName));
		json.put("studentName", checkNull(this.studentName));
		json.put("teacherName", checkNull(this.teacherName));
		json.put("startTime", checkNull(this.startTime));
		json.put("endTime", checkNull(this.endTime));
		json.put("orgMobile", checkNull(this.orgMobile));
		
		return json.toString();
	}
	
	

	public void setOrgId(Integer orgId){
		this.orgId = orgId;
	}
	public void setOrgId(Long orgId){
		this.orgId = Integer.parseInt(orgId.toString());
	}
}

