/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.dao.PreAuthCodeDao;
import com.baijia.tianxiao.dal.wechat.po.PreAuthCode;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.sal.wechat.api.PreAuthCodeService;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.openplat.OpenPlatApiHelper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PreAuthCodeServiceImpl
implements PreAuthCodeService {
    private static final Logger log = LoggerFactory.getLogger(PreAuthCodeServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(PreAuthCodeServiceImpl.class);
    @Autowired
    private PreAuthCodeDao preAuthCodeDao;
    @Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;

    @Override
    @Transactional(readOnly=true)
    public PreAuthCode get() {
        String appId = WechatProperties.getOpenAppId();
        PreAuthCode newPreAuthCode = null;
        try {
            String componentAccessToken = this.componentAccessTokenDao.getByAppId(appId).getComponentAccessToken();
            newPreAuthCode = OpenPlatApiHelper.requestPreAuthCode(appId, componentAccessToken);
        }
        catch (Exception e) {
            log.error("PreAuthCode - refresh - exception", (Throwable)e);
            throw new PermissionException("\u5237\u65b0\u9884\u6388\u6743\u7801\u5931\u8d25,\u8bf7\u91cd\u65b0\u8bbf\u95ee\u3002");
        }
        return newPreAuthCode;
    }

    @Override
    @Transactional(readOnly=true)
    public PreAuthCode getByAppId(String appId) {
        return this.preAuthCodeDao.getByAppId(appId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update() {
        String appId = WechatProperties.getOpenAppId();
        String componentAccessToken = this.componentAccessTokenDao.getByAppId(appId).getComponentAccessToken();
        PreAuthCode newPreAuthCode = OpenPlatApiHelper.requestPreAuthCode(appId, componentAccessToken);
        PreAuthCode preAuthCode = this.getByAppId(appId);
        if (preAuthCode == null) {
            this.preAuthCodeDao.save((Object)newPreAuthCode, Boolean.valueOf(true), new String[0]);
            logger.info("wechat - add new preauthcode:{}", (Object)newPreAuthCode);
            return;
        }
        preAuthCode.setUpdateTime(new Date());
        preAuthCode.setExpiresIn(newPreAuthCode.getExpiresIn());
        preAuthCode.setPreAuthCode(newPreAuthCode.getPreAuthCode());
        this.preAuthCodeDao.update((Object)preAuthCode, Boolean.valueOf(true), new String[0]);
        logger.info("wechat - update preauthcode:{}", (Object)preAuthCode);
    }
}

