/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.webauth;

import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthorizationDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.webauth.WechatWebAuthCaller;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatWebAuthHelper {
    private static final Logger log = LoggerFactory.getLogger(WechatWebAuthHelper.class);

    public static WebAuthorizationDto getWebAuthorization(String appId, String code, String compAppId, String compAccessToken) {
        WebAuthorizationDto dto = null;
        WechatApiResponse result = WechatWebAuthCaller.getWebAuthorization(appId, code, compAppId, compAccessToken);
        if (result != null && !result.isError()) {
            dto = WebAuthorizationDto.fromJson(result.getJsonStr());
        } else {
            log.warn("wechat - getWebAuthorizationDtoByWebAuthCode - fail - json:{}", (Object)result);
        }
        return dto;
    }

    public static Fans getUserInfoByWebAuth(String webAuthAccessToken, String openId) {
        Fans fans = null;
        WechatApiResponse result = WechatWebAuthCaller.getUserInfoByWebAuth(webAuthAccessToken, openId);
        if (!result.isError()) {
            fans = new Fans();
            JSONObject rootNode = result.getRootJSONObj();
            fans.setOpenId(rootNode.getString("openid"));
            fans.setNick(rootNode.optString("nickname", ""));
            fans.setHeadImgUrl(rootNode.optString("headimgurl", ""));
            fans.setSex(Integer.valueOf(rootNode.optInt("sex", 0)));
            fans.setCity(rootNode.optString("city", ""));
            fans.setProvince(rootNode.optString("province", ""));
            fans.setCountry(rootNode.optString("country", ""));
        } else {
            log.warn("wechat - getWechatUserByWebAuthCode - fail - json:{}", (Object)result);
        }
        return fans;
    }
}

