/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.menu;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatMenuApiCaller {
    private static final Logger logger = LoggerFactory.getLogger(WechatMenuApiCaller.class);

    public static WechatApiResponse getMenu(String accessToken) throws WechatException, WebServiceException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=" + accessToken;
        return WechatRemoteCallHelper.get(url);
    }

    public static WechatApiResponse deleteMenu(String accessToken) throws WechatException, WebServiceException {
        logger.info("delete wechat menu - accessToken:{}", (Object)accessToken);
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=" + accessToken;
        return WechatRemoteCallHelper.get(url);
    }

    public static WechatApiResponse createMenu(String accessToken, Map<String, Object> menu) throws WechatException, WebServiceException {
        logger.info("create wechat menu - accessToken:{}", (Object)accessToken);
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + accessToken;
        return WechatRemoteCallHelper.postJson(url, menu);
    }

    public static WechatApiResponse createMenu(String accessToken, String menuJson) throws WechatException, WebServiceException {
        logger.info("create wechat menu - accessToken:{}", (Object)accessToken);
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + accessToken;
        return WechatRemoteCallHelper.postJson(url, (Map<String, Object>)JSONObject.fromObject((Object)menuJson));
    }

    public static void main(String[] args) {
        String accessToken = "4Vv9feQbopgYAaWEZMGoExdx4g7Vbcmkl5E7nPErzNttP1bIGv1udw5y4qIhU4Oh_NCcsOhVHylzGrHgvDfQcc45xpKrNCgg08pM9TxWlW80p3qUCnH3Z3jgbOwWvKsWJUSdAEDEPN";
        System.out.print(WechatMenuApiCaller.getMenu(accessToken));
    }
}

