/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncType;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatDataSyncLogDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatDataSyncLog;
import com.baijia.tianxiao.sal.wechat.api.WechatDataSyncLogService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WechatDataSyncLogServiceImpl
implements WechatDataSyncLogService {
    private static final Logger log = LoggerFactory.getLogger(WechatDataSyncLogServiceImpl.class);
    @Autowired
    private OrgWechatDataSyncLogDao orgWechatDataSyncLogDao;

    @Override
    public boolean hasTaskOngoing(String authorizerAppId, WechatDataSyncType type) {
        if (this.orgWechatDataSyncLogDao.countOnGoingAndUnExpired(authorizerAppId, WechatDataSyncType.FANS) > 0) {
            log.info("Wechat - hasTaskOngoing - run - stop by other task is ongoing - authorizerAppId:{}", (Object)authorizerAppId);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void saveOrUpdateInNewTransaction(OrgWechatDataSyncLog dataSyncLog) {
        this.orgWechatDataSyncLogDao.saveOrUpdate((Object)dataSyncLog, new String[0]);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public OrgWechatDataSyncLog buildDefaultLog(String authorizerAppId, WechatDataSyncType type, Date startTime, Integer amountExpected, Date expireTime) {
        OrgWechatDataSyncLog dataSyncLog = OrgWechatDataSyncLog.buildDefaultLog((String)authorizerAppId, (WechatDataSyncType)WechatDataSyncType.FANS, (Date)startTime, (Integer)amountExpected, (Date)expireTime);
        this.orgWechatDataSyncLogDao.saveOrUpdate((Object)dataSyncLog, new String[0]);
        return dataSyncLog;
    }
}

