/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForKeywordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForSubscribeDao;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessageReceiveService;
import com.baijia.tianxiao.sal.wechat.api.ReleaseTest;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.WechatOpenIdRecordService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.FreeVersionMenuClick;
import com.baijia.tianxiao.sal.wechat.constant.emoticons.WechatEmoticons;
import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.constant.wechatmsg.WechatMsgType;
import com.baijia.tianxiao.sal.wechat.dto.common.WechatMessagePayload;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.msgtoapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.org.OrgCenterInfo;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStr;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrActivity;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrSubscribeOrg;
import com.baijia.tianxiao.sal.wechat.dto.request.MessageRequest;
import com.baijia.tianxiao.sal.wechat.dto.unifiedWechatAccount.CampusInfoDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatLocationEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSCANEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSubscribeEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatImageMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatOrdinaryMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatTextMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatVoiceMessage;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.AutoReplyHelper;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.KeyWordMatcher;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgHelper;
import com.baijia.tianxiao.sal.wechat.helper.common.WechatCryptUtils;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiCaller;
import com.baijia.tianxiao.sal.wechat.helper.user.FansServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.AudioUtil;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MessageReceiveServiceImpl
implements MessageReceiveService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MessageReceiveServiceImpl.class);
    private static final String RELEASE_TEST_USERNAME = "gh_3c884a361561";
    @Autowired
    private ReleaseTest releaseTest;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgWechatReplyForKeywordDao replyForKeywordDao;
    @Autowired
    private OrgWechatReplyForSubscribeDao replySubscribeDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;
    @Autowired
    private UnifiedWechatAccountService unifiedWechatAccountService;
    @Autowired
    private OrganizationInfoAPIService organizatinInfoAPIService;
    @Autowired
    private TX400PhoneDao tx400PhoneDao;
    @Autowired
    private WechatOpenIdRecordService wechatOpenIdRecordService;
    @Autowired
    private RedisDefaultService redisDefaultService;
    @Autowired(required=false)
    private CloudAccount cloudAccount;
    private CloudQueue consultMsgQueue;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    public static final List<Integer> excludeForSubscribeOrgIds = Lists.newArrayList((Iterable)GenericsUtils.stringToNumber((String)"1186", Integer.class));
    public static final String fixedReplayForUnifiedWechatAccountFormat = "<a href='%s'>\u70b9\u51fb\u8fd9\u91cc</a>\u9009\u62e9\u60f3\u8981\u54a8\u8be2\u7684\u6821\u533a\n";
    public static final String lastChatUrlAppendFormat = "\u8bf7\u9009\u62e9\u60f3\u8981\u54a8\u8be2\u7684\u6821\u533a\n\n1.\u60a8\u4e0a\u6b21\u54a8\u8be2[%s]\u6821\u533a\uff0c<a href='%s'>\u70b9\u51fb\u7ee7\u7eed\u54a8\u8be2</a>\n\n2.\u54a8\u8be2\u65b0\u6821\u533a\uff0c<a href='%s'>\u70b9\u51fb\u9009\u62e9</a>";

    @Override
    public String generateDefaultResponse() {
        return "";
    }

    /*
     * Exception decompiling
     */
    @Override
    public String handle(MessageRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void filterWrongUsers(WechatOrdinaryMessage ordinaryMessage) {
        if (ordinaryMessage.getMsgType() == WechatMsgType.TEXT) {
            WechatTextMessage message = (WechatTextMessage)ordinaryMessage;
            String content = message.getContent();
            String toUserName = message.getToUserName();
            if (GenericsUtils.notNullAndEmpty((Object)content) && content.contains("https://hd.tianxiao100.com/toupiao.html?templateId=5&activityId=584&activityType=5") && toUserName.equals("gh_97d45a558bfc")) {
                log.info("wrong info :{} ", (Object)message);
                throw new RuntimeException("wrong info ");
            }
        }
    }

    private void setUserChatInfo(String openId, WechatMessagePayload createWechatMessagePayload) {
        log.info("openId :{} --- > createWechatMessagePayload is :{} ", (Object)openId, (Object)createWechatMessagePayload);
        if (createWechatMessagePayload == null) {
            return;
        }
        try {
            this.redisDefaultService.set(WechatMessagePayload.getKey(openId), WechatMessagePayload.instanceJsonPayloadFromWeChat(createWechatMessagePayload.getLastChatOrgId()));
            log.info("success to set chat payload for user : {} , {} ", (Object)createWechatMessagePayload, (Object)createWechatMessagePayload.getLastChatOrgId());
        }
        catch (Exception e) {
            log.info("[reset error] :{} ", (Object)createWechatMessagePayload, (Object)createWechatMessagePayload.getLastChatOrgId());
        }
    }

    private String generateEventResponse(WechatEventMessage message) {
        switch (message.getEvent()) {
            case SUBSCRIBE: {
                boolean isUnifiedWechatAccount;
                WechatSubscribeEventMessage subscribeMsg = (WechatSubscribeEventMessage)message;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(subscribeMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                if (StringUtils.isNotBlank((CharSequence)subscribeMsg.getTicket())) {
                    String params = subscribeMsg.getEventKey();
                    QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);
                    if (qwCodeType != null) {
                        switch (qwCodeType) {
                            case CUSTOM_ACTIVITY: {
                                QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                                OrgWechatCustomActivity customActivity = this.customActivityDao.get(dto.getActivityId().intValue(), dto.getActivityType().intValue());
                                Template template = this.templateDao.selectTemplateById(dto.getActivityType());
                                String relativePath = template != null ? template.getUrl() : null;
                                String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(), customActivity.getActivityType(), relativePath);
                                return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), customActivity.getTitle(), customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                            }
                            case SUBCRIBE_WITH_ORG_ID: {
                                QRCodeSceneStrSubscribeOrg dto1 = QRCodeSceneStrSubscribeOrg.fromSceneStr(params);
                                String freeVersionCheck = this.orgIdQrCodeReply4FreeVersion(authorizerInfo, message, dto1.getOrgId());
                                if (freeVersionCheck == null) break;
                                return freeVersionCheck;
                            }
                        }
                    } else {
                        log.warn("wechat QRCodeType is null - params:{}", (Object)params);
                    }
                }
                OrgWechatReplyForSubscribe reply = this.replySubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId());
                String replyContent = PassiveReplyMsgHelper.getSubscribeReply(subscribeMsg.getToUserName(), subscribeMsg.getFromUserName(), reply);
                Integer orgId = authorizerInfo.getOrgId();
                OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
                OrgWechatDto owDto = new OrgWechatDto(orgId, orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
                log.info("reply is :{}  and replyContent : {} ", (Object)reply, (Object)replyContent);
                if (excludeForSubscribeOrgIds.contains(orgId)) {
                    log.info("find a orgId :{} in white record , so will return default response", (Object)orgId);
                    return this.generateDefaultResponse();
                }
                boolean bl = isUnifiedWechatAccount = this.unifiedWechatAccountDao.findUnifiedWechatRecord(Long.valueOf(orgId.longValue()), true, Integer.valueOf(DeleteStatus.NORMAL.getValue())) != null;
                if (reply != null && !replyContent.equals("success")) {
                    AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
                    try {
                        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                        if (isUnifiedWechatAccount) {
                            MediaType type = MediaType.getByVaule(reply.getMediaType());
                            log.info("media type is :{} ", (Object)type.getLabel());
                            if (type == MediaType.CONTENT) {
                                String newContent = reply.getContent() + "\n\n" + this.appendMessage(owDto);
                                reply.setContent(newContent);
                            }
                        }
                        AutoReplyHelper.sendSubscribeReply(authorizationInfo.getAuthorizerAccessToken(), subscribeMsg.getFromUserName(), reply);
                        break;
                    }
                    catch (Exception e) {
                        log.error("send subscribeReply error :{} ", (Throwable)e);
                        return this.getDefaultSubscribeReply(subscribeMsg, authorizerInfo, isUnifiedWechatAccount);
                    }
                }
                log.info("will reply default value ");
                return this.getDefaultSubscribeReply(subscribeMsg, authorizerInfo, isUnifiedWechatAccount);
            }
            case UNSUBSCRIBE: {
                break;
            }
            case SCAN: {
                WechatSCANEventMessage scanMsg = (WechatSCANEventMessage)message;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(scanMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                if (!StringUtils.isNotBlank((CharSequence)scanMsg.getTicket())) break;
                String params = scanMsg.getEventKey();
                QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);
                if (qwCodeType != null) {
                    switch (qwCodeType) {
                        case CUSTOM_ACTIVITY: {
                            QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                            OrgWechatCustomActivity customActivity = this.customActivityDao.get(dto.getActivityId().intValue(), dto.getActivityType().intValue());
                            Template template = this.templateDao.selectTemplateById(dto.getActivityType());
                            String relativePath = template != null ? template.getUrl() : null;
                            String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(), customActivity.getActivityType(), relativePath);
                            return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), customActivity.getTitle(), customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                        }
                        case SUBCRIBE_WITH_ORG_ID: {
                            QRCodeSceneStrSubscribeOrg dto1 = QRCodeSceneStrSubscribeOrg.fromSceneStr(params);
                            String freeVersionCheck = this.orgIdQrCodeReply4FreeVersion(authorizerInfo, message, dto1.getOrgId());
                            if (freeVersionCheck == null) break;
                            return freeVersionCheck;
                        }
                    }
                    break;
                }
                log.warn("wechat - unknow qwCodeType - params:{}", (Object)params);
                break;
            }
            case LOCATION: {
                break;
            }
            case MENU_CLICK: {
                AuthorizationInfo authorizationInfo;
                String content;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                this.sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                String freeVersionCheck = this.menuClick4FreeVersion(authorizerInfo, message);
                if (freeVersionCheck != null) {
                    return freeVersionCheck;
                }
                OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                if (menu == null) break;
                Map<String, String> keyVsContentMap = WechatMenuJsonConverter.mapClickKeyVsContent(menu.getJson());
                log.info("eventKey is:{} and keyVsContentMap are :{} ", (Object)message.getEventKey(), keyVsContentMap);
                if (keyVsContentMap == null || keyVsContentMap.isEmpty() || !StringUtils.isNotBlank((CharSequence)(content = keyVsContentMap.get(message.getEventKey()))) || (authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId())) == null) break;
                CustomerServiceApiCaller.sendTextMsg(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), content);
                break;
            }
            case MENU_VIEW: {
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                this.sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                break;
            }
            case UNKNOWN: {
                log.warn("wechat - receive unknown event message - message:{}", (Object)message);
            }
        }
        return this.generateDefaultResponse();
    }

    private String appendMessage(OrgWechatDto owDto) {
        StringBuilder sb = new StringBuilder(WechatProperties.getWebMTianXiaoUrlPrefix());
        sb.append(String.format(WechatProperties.getCampusListUrlFormat(), owDto.getOrgNumber(), owDto.getAppId()));
        String campusListUrl = WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, owDto.getAppId(), sb.toString());
        String shortUrl = ShortUrlUtil.getShortUrl((String)campusListUrl);
        String info1 = this.getHrefLink(shortUrl, "\u8bf7\u70b9\u51fb\u8fd9\u91cc");
        String appendContent = "\u67e5\u770b\u6821\u533a\u5730\u5740/\u5728\u7ebf\u54a8\u8be2 %s";
        return String.format(appendContent, info1);
    }

    String getDefaultSubscribeReply(WechatSubscribeEventMessage message, AuthorizerInfo authorizerInfo, boolean isUnifiedWechatAccount) {
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            StringBuilder content = new StringBuilder();
            content.append("\u6b22\u8fce\u5173\u6ce8" + authorizerInfo.getNickName() + "\uff01\n");
            content.append("\u6dfb\u52a0\u673a\u6784\u540e\uff0c\u4f60\u53ef\u4ee5\u5728\u7ebf\u8054\u7cfb\u673a\u6784\uff0c\u5728\u4e2a\u4eba\u4e2d\u5fc3\u67e5\u770b\u81ea\u5df1\u7684\u8bfe\u7a0b\u53ca\u7b7e\u5230\u60c5\u51b5\u7b49\u4fe1\u606f\u54e6\uff01\n");
            content.append("\u5982\u4f55\u6dfb\u52a0\u673a\u6784\uff1f\n");
            content.append("\u626b\u63cf\u673a\u6784\u7684\u4e8c\u7ef4\u7801\uff0c\u6216\u8005\u76f4\u63a5\u5728\u5bf9\u8bdd\u6846\u4e2d\u8f93\u5165\u673a\u6784\u7684\u5929\u6821\u53f7\u5c31\u53ef\u4ee5\u4e86\uff01");
            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
        }
        Integer orgId = authorizerInfo.getOrgId();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        OrgWechatDto owDto = new OrgWechatDto(orgId, orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        StringBuilder content = new StringBuilder();
        content.append("\u81f4\u4eb2\u7231\u7684\u4f60\uff1a\n\n");
        content.append("\u6b22\u8fce\u52a0\u5165").append(orgInfo.getShortName()).append("\u5927\u5bb6\u5ead!").append("\n\n");
        content.append(this.getHrefLink(MediaType.WANGXIAOZHUYE.getUrl(owDto), orgInfo.getShortName() + "\u5fae\u5b98\u7f51\u6b63\u5f0f\u4e0a\u7ebf\u5566!\u8fdb\u6765\u770b\u770b\u6709\u60ca\u559c\u54e6!")).append("\n\n");
        content.append("\u73b0\u5728\u9884\u7ea6\u4f53\u9a8c\u8bfe\uff0c\u83b7\u8c6a\u534e\u5927\u793c\u5305\uff08\u4ec5\u9650\u9996\u6b21\u9884\u7ea6\u7528\u6237\uff09\uff0c\u8fd8\u5728\u7b49\u4ec0\u4e48\uff0c\u70b9\u51fb").append(this.getHrefLink(MediaType.YUYUESHITING.getUrl(owDto), "\u9884\u7ea6\u8bd5\u542c")).append("!").append("\n\n");
        content.append("\u54a8\u8be2\u8bfe\u7a0b\uff1f\u6b22\u8fce\u7559\u4e0b\u60a8\u7684\u59d3\u540d\u3001\u8054\u7cfb\u65b9\u5f0f\uff0c\u6211\u4eec\u4f1a\u6709\u4e13\u4e1a\u7684\u8001\u5e08\u5e2e\u60a8\u8be6\u7ec6\u89e3\u7b54\u3002").append("\n\n");
        if (authorizerInfo.hasWebAuthPermission()) {
            content.append("\u60f3\u5feb\u901f\u67e5\u8bfe\u8868\u3001\u5199\u8bc4\u4ef7\u3001\u770b\u4e0a\u8bfe\u8bb0\u5f55\uff1f\u4e0d\u8bba\u662f\u5b66\u751f\u8fd8\u662f\u8001\u5e08\uff0c\u53ef\u5728\u201c").append(this.getHrefLink(MediaType.XUESHENGZHONGXIN.getUrl(owDto), "\u5b66\u751f\u4e2d\u5fc3")).append("/").append(this.getHrefLink(MediaType.LAOSHIZHONGXIN.getUrl(owDto), "\u8001\u5e08\u4e2d\u5fc3")).append("\u201d\u8f7b\u677e\u5b8c\u6210\uff0c\u9a6c\u4e0a\u8fdb\u884c\u8eab\u4efd\u9a8c\u8bc1\u5427\u3002").append("\n\n");
        }
        if (!isUnifiedWechatAccount) {
            TX400Phone tx400Phone = this.tx400PhoneDao.getByOrgId(orgId);
            if (tx400Phone != null && !Flag.getBoolean((Integer)tx400Phone.getIsdel())) {
                content.append("\u6709\u8bdd\u5bf9\u6211\u4eec\u8bf4\uff1f\u6b22\u8fce\u6253\u7535\u8bdd\u7ed9\u6211\u4eec\u54df~ ").append(tx400Phone.getPhone400()).append(" \uff0c\u6211\u4eec\u5c06\u6089\u5fc3\u8046\u542c\uff0c\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002").append("\n\n");
            } else {
                content.append("\u6709\u8bdd\u5bf9\u6211\u4eec\u8bf4\uff1f\u6b22\u8fce\u6253\u7535\u8bdd\u7ed9\u6211\u4eec\u54df~ ").append(WechatProperties.getMobileNumber400Main() + "\u8f6c" + orgInfo.getExtension()).append(" \uff0c\u6211\u4eec\u5c06\u6089\u5fc3\u8046\u542c\uff0c\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002").append("\n\n");
            }
            content.append("\u7cbe\u5f69\u6d3b\u52a8\uff0c\u656c\u8bf7\u5173\u6ce8\uff01").append("\n\n");
        } else {
            log.info("======append ");
            content.append(this.appendMessage(owDto));
        }
        log.info("content is : {} ", (Object)content.toString());
        return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
    }

    String getHrefLink(String href, String content) {
        String link = "<a href=\"%s\">%s</a>";
        return String.format(link, href, content);
    }

    void sendMenuVisitMonitor(AuthorizerInfo authorizerInfo, String openId) {
        if (authorizerInfo == null || StringUtils.isBlank((CharSequence)openId)) {
            return;
        }
        try {
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
            String url = WechatProperties.getWebCRMUrlPrefix() + "monitor.do";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orgNumber", orgAccount.getNumber() + "");
            params.put("userNumber", openId);
            params.put("typeNumber", "10");
            HttpClientUtils.doGet((String)url, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String generateOrdinaryResponse(WechatOrdinaryMessage message) throws WechatException, WebServiceException, Exception {
        String unifiedCommonReply;
        String reply = "";
        ReplyResultStatus rrs = new ReplyResultStatus();
        switch (message.getMsgType()) {
            case TEXT: {
                log.info("rrs is:{} ", (Object)rrs);
                reply = this.generateTextOrdinaryResponse((WechatTextMessage)message, rrs);
                break;
            }
            case IMAGE: {
                reply = this.generateImageOrdinaryResponse((WechatImageMessage)message);
                break;
            }
            case VOICE: {
                reply = this.generateVoiceOrdinaryResponse((WechatVoiceMessage)message);
                break;
            }
            case VIDEO: {
                break;
            }
            case SHORT_VIDEO: {
                break;
            }
            case LOCATION: {
                break;
            }
            case LINK: {
                break;
            }
            case UNKNOWN: {
                log.warn("wechat - receive unknown type message - message:{}", (Object)message);
                break;
            }
        }
        log.info("ReplyResultStatus is :{} ", (Object)rrs);
        if (!rrs.isAuthReply() && GenericsUtils.notNullAndEmpty((Object)(unifiedCommonReply = this.addUnifiedWechatAccountReoly(message)))) {
            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), unifiedCommonReply);
        }
        if (GenericsUtils.notNullAndEmpty((Object)reply)) {
            return reply;
        }
        return this.generateDefaultResponse();
    }

    private String addUnifiedWechatAccountReoly(WechatOrdinaryMessage message) {
        String toUserName = message.getToUserName();
        String fromUserName = message.getFromUserName();
        AuthorizerInfo byUserName = this.authorizerInfoDao.getByUserName(toUserName);
        if (byUserName == null) {
            return null;
        }
        String appId = byUserName.getAuthorizerAppId();
        Long orgId = byUserName.getOrgId().longValue();
        UnifiedWechatAccount findUnifiedWechatRecord = this.unifiedWechatAccountDao.findUnifiedWechatRecord(orgId, true, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
        StringBuilder sb = new StringBuilder();
        if (findUnifiedWechatRecord != null && fans != null && fans.isSubscribed()) {
            Integer replyFormatType = 1;
            String campusListUrl = "";
            String orgName = "";
            String lastChatCampusUrl = "";
            log.info("find a wechat account with orgId:{} is a unifiedWechatAccount ,and will return fixed reply ");
            OrgAccount orgAccount = this.organizatinInfoAPIService.findOrgAccountWithOrgId(orgId);
            Integer orgNumber = orgAccount.getNumber();
            String createCampusListUrl = this.unifiedWechatAccountService.createCampusListUrl(orgNumber, appId);
            campusListUrl = ShortUrlUtil.getShortUrl((String)createCampusListUrl);
            String lastChatOrgIdStr = this.redisDefaultService.get(this.getKey(message.getFromUserName()));
            log.info("lastChatOrgIdStr is :{} ", (Object)lastChatOrgIdStr);
            WechatMessagePayload createWechatMessagePayload = null;
            if (GenericsUtils.notNullAndEmpty((Object)lastChatOrgIdStr)) {
                createWechatMessagePayload = WechatMessagePayload.createWechatMessagePayload(lastChatOrgIdStr);
                log.info("createWechatMessagePayload is :{} ", (Object)createWechatMessagePayload);
                Integer lastChatOrgId = null;
                if (createWechatMessagePayload != null) {
                    lastChatOrgId = createWechatMessagePayload.getLastChatOrgId();
                    OrgBaseInfoDto orgInfo = this.orgInfoDao.getBaseInfo(lastChatOrgId.intValue());
                    orgName = orgInfo.getShortName();
                    OrgAccount findOrgAccountWithOrgId = this.organizatinInfoAPIService.findOrgAccountWithOrgId(Long.valueOf(lastChatOrgId.longValue()));
                    String createChatUrl = this.unifiedWechatAccountService.createChatUrl(appId, lastChatOrgId, findOrgAccountWithOrgId.getNumber(), fromUserName);
                    lastChatCampusUrl = ShortUrlUtil.getShortUrl((String)createChatUrl);
                    replyFormatType = 2;
                }
            }
            if (replyFormatType == 1) {
                sb.append(String.format(fixedReplayForUnifiedWechatAccountFormat, campusListUrl));
            } else {
                sb.append(String.format(lastChatUrlAppendFormat, orgName, lastChatCampusUrl, campusListUrl));
            }
            this.setUserChatInfo(message.getFromUserName(), createWechatMessagePayload);
        } else {
            sb.append("");
        }
        return sb.toString();
    }

    private String getKey(String fromUserName) {
        return fromUserName + "_LAST_CHAT";
    }

    private String generateTextOrdinaryResponse(WechatTextMessage message, ReplyResultStatus replyResultStatus) {
        log.info("\u666e\u901a\u6d88\u606f-\u6587\u672c {} , and replyResultStatus is:{}  ", (Object)message, (Object)replyResultStatus);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        if (authorizerInfo == null) {
            return this.generateDefaultResponse();
        }
        Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
        String freeVersionCheck = this.txNumerReply4FreeVersion(authorizerInfo, message);
        if (freeVersionCheck != null) {
            return freeVersionCheck;
        }
        if (fans != null) {
            MessageDto dto = new MessageDto(MsgType.TEXT.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
            dto.setTextContent(WechatEmoticons.convert(message.getContent()));
            this.putWechatMessageIntoMQ(dto, authorizerInfo, fans);
        }
        try {
            String keywordReply = this.getKeywordReply(message, authorizerInfo, replyResultStatus);
            log.info("replyResultStatus is :{} and keywordReply is :{} ", (Object)replyResultStatus, (Object)keywordReply);
            if (keywordReply != null) {
                return keywordReply;
            }
        }
        catch (Exception e) {
            log.error("keywordReply error is :{} ", (Throwable)e);
        }
        return this.generateDefaultResponse();
    }

    private void putWechatMessageIntoMQ(MessageDto dto, AuthorizerInfo authorizerInfo, Fans fans) {
        Integer orgId = authorizerInfo.getOrgId();
        try {
            UnifiedWechatAccount findUnifiedWechatRecord = this.unifiedWechatAccountDao.findUnifiedWechatRecord(Long.valueOf(orgId.longValue()), true, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            log.info("find a findUnifiedWechatRecord :{} with message:{} from fans:{} ", new Object[]{findUnifiedWechatRecord, dto, fans});
            if (findUnifiedWechatRecord != null && findUnifiedWechatRecord.isMaster() && findUnifiedWechatRecord.isInitOver()) {
                log.info("find current message from a unifiedWechatAccount , so will not put it into MQ :{}", (Object)findUnifiedWechatRecord);
                return;
            }
        }
        catch (Exception ex) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)ex, (String)"encount a exception while search findUnifiedWechatRecord with orgId:{}  ", (Object[])new Object[]{orgId});
        }
        String msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJsonStr());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
    }

    String getKeywordReply(WechatTextMessage message, AuthorizerInfo authorizerInfo, ReplyResultStatus replyResultStatus) {
        List replyList = this.replyForKeywordDao.search(authorizerInfo.getAuthorizerAppId(), null);
        OrgWechatReplyForKeyword reply = KeyWordMatcher.match(message.getContent(), replyList);
        log.info("for message :{}  and replyResultStatus is:{}  and reply is :{}", new Object[]{message, replyResultStatus, reply});
        if (reply != null) {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            try {
                WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                AutoReplyHelper.sendKeywordReply(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), reply);
                log.info("find a auth reply ,so will set replyResultStatus true :{} ", (Object)replyResultStatus);
                if (replyResultStatus != null) {
                    replyResultStatus.setAuthReply(true);
                }
            }
            catch (Exception e) {
                log.error("log error :{} ", (Throwable)e);
                return PassiveReplyMsgHelper.getKeywordReply(message.getToUserName(), message.getFromUserName(), reply);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateImageOrdinaryResponse(WechatImageMessage message) throws WechatException, WebServiceException, Exception {
        block13: {
            block14: {
                MessageReceiveServiceImpl.log.info("is image message :{} ", (Object)message);
                fans = this.fansDao.getByOpenId(message.getFromUserName());
                if (fans == null) {
                    return this.generateDefaultResponse();
                }
                authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
                    return this.generateDefaultResponse();
                }
                authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
                if (authorizationInfo == null) {
                    return this.generateDefaultResponse();
                }
                MessageReceiveServiceImpl.log.info("prepared to upload file to remote");
                uid = Long.parseLong(authorizerInfo.getOrgId() + "");
                localFile = null;
                storageId = null;
                url = null;
                data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
                if (data != null) {
                    MessageReceiveServiceImpl.log.info("data is :{} ", (Object)data.length);
                }
                localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                result = FileUploadUtils.uploadToRemote(uid, localFile, false);
                if (localFile != null) {
                    MessageReceiveServiceImpl.log.info("local file's path is :{} ", (Object)localFile.getAbsolutePath());
                }
                if ((saveToObj = this.saveToObj(result, MIMEType.JPG)) != null) {
                    this.saveToDb(saveToObj);
                    storageId = saveToObj.getId();
                    MessageReceiveServiceImpl.log.info("saveToObj is :{} ", (Object)saveToObj);
                    url = StorageUtil.constructUrl(saveToObj.getFid(), saveToObj.getSn(), saveToObj.getMimeType());
                    MessageReceiveServiceImpl.log.info("url is :{} ", (Object)url);
                    break block13;
                }
                MessageReceiveServiceImpl.log.info("update file with message fail :{} so will return generatoeDefaultResponse", (Object)message);
                var14_13 = this.generateDefaultResponse();
                if (localFile == null) break block14;
                LocalFileHelper.deleteFile(localFile);
            }
            return var14_13;
        }
        try {
            image = ImageIO.read(localFile);
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block15: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateImageOrdinaryResponse - exception", (Throwable)e);
                    var12_11 = this.generateDefaultResponse();
                    if (localFile == null) break block15;
                }
                catch (Throwable var15_17) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var15_17;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return var12_11;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        dto = new MessageDto(MsgType.PICTURE.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setImageContent(storageId, url, imageHeight, imageWidth);
        this.putWechatMessageIntoMQ(dto, authorizerInfo, fans);
        return this.generateDefaultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateVoiceOrdinaryResponse(WechatVoiceMessage message) throws WechatException, WebServiceException, Exception {
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            return this.generateDefaultResponse();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getRecognition())) {
            textMessage = new WechatTextMessage("[\u8bed\u97f3\u8bc6\u522b] " + message.getRecognition());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage, null);
        }
        if (!message.getFormat().toLowerCase().equals("amr")) {
            textMessage = new WechatTextMessage("[\u4e0d\u652f\u6301\u7684\u8bed\u97f3\u7c7b\u578b] " + message.getFormat().toLowerCase());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage, null);
        }
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            return this.generateDefaultResponse();
        }
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.AMR);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.AMR);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            voiceLength = Integer.parseInt(AudioUtil.getAmrDuration(localFile) + "");
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block10: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateVoiceOrdinaryResponse - exception", (Throwable)e);
                    var11_12 = this.generateDefaultResponse();
                    if (localFile == null) break block10;
                }
                catch (Throwable var12_16) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var12_16;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return var11_12;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        dto = new MessageDto(MsgType.VOICE.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setVoiceContent(storageId, StorageUtil.constructUrl(orgStorage), voiceLength);
        this.putWechatMessageIntoMQ(dto, authorizerInfo, fans);
        return this.generateDefaultResponse();
    }

    private String generateSubscribeEventResponse(WechatSubscribeEventMessage message) {
        try {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(authorizerInfo.getOrgId(), new String[0]);
            OrgTxtMsg brief = this.orgTxtMsgDao.getOrgTxtByIdAndType(authorizerInfo.getOrgId().intValue(), 3101);
            StringBuilder msg = new StringBuilder();
            String intro = "";
            if (brief != null && StringUtils.isNotBlank((CharSequence)brief.getValue())) {
                intro = brief.getValue();
            }
            msg.append("\u611f\u8c22\u5173\u6ce8\u3010").append(orgInfo.getShortName()).append("\u3011\u3002").append(intro);
            String content = msg.toString();
            String response = WechatCryptUtils.encryptMsg(message.getFromUserName(), message.getToUserName(), "text", content);
            log.info("wechat - return subscribe event response:{}", (Object)response);
            return response;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private Integer saveToDb(UploadResult uploadResult, MIMEType mimeType) {
        OrgStorage orgStorage = this.saveToObj(uploadResult, mimeType);
        if (orgStorage == null) {
            return null;
        }
        this.orgStorageDao.save((Object)orgStorage, Boolean.valueOf(true), new String[0]);
        return orgStorage.getId();
    }

    private void saveToDb(OrgStorage orgStorage) {
        if (orgStorage != null) {
            this.orgStorageDao.save((Object)orgStorage, Boolean.valueOf(true), new String[0]);
        }
    }

    private OrgStorage saveToObj(UploadResult uploadResult, MIMEType mimeType) {
        List uploadFiles = uploadResult.getFiles();
        if (uploadFiles.size() == 0) {
            return null;
        }
        UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)uploadFiles.get(0);
        OrgStorage orgStorage = new OrgStorage();
        orgStorage.setFid(uploadFile.getFid());
        orgStorage.setSn(uploadFile.getSn());
        orgStorage.setSize(Integer.valueOf(uploadFile.getSize()));
        orgStorage.setMimeType(Integer.valueOf(mimeType.getCode()));
        Date now = new Date();
        orgStorage.setCreateTime(now);
        orgStorage.setUpdateTime(now);
        orgStorage.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStorage.setSource(Short.valueOf((short)0));
        return orgStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstTimeHandle(String key) {
        log.info("Wechat - isFirstTimeHandle - check - key:{}", (Object)key);
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB().intValue());
            if (connection.exists(key.getBytes()).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            connection.setEx(key.getBytes(), 20L, "".getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Wechat - isFirstTimeHandle - exception - e:{}", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public Fans fansPretreatment(WechatAbstractMessage message) {
        Fans fans = null;
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        if (authorizerInfo == null || !authorizerInfo.isPassedVerify() || authorizerInfo.getFansSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()) {
            return null;
        }
        if (fans == null) {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            if (authorizationInfo == null || !authorizationInfo.hasFunc(Integer.valueOf(WechatPermission.USER_MANAGE.getValue()))) {
                return null;
            }
            try {
                fans = FansServiceApiHelper.getFansInfo(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fans == null) {
                return null;
            }
            fans.initBasicAttribute();
            if (message instanceof WechatOrdinaryMessage) {
                fans.setLastCommunicationTime(new Date());
            } else {
                fans.setLastCommunicationTime(new Date(0L));
            }
            fans.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            if (StringUtils.isNotBlank((CharSequence)fans.getHeadImgUrl()) && WechatProperties.getSwitchFansImgConvert()) {
                try {
                    MIMEType mime = MIMEType.JPG;
                    UploadResult result = FileUploadUtils.uploadToRemote(0L, fans.getHeadImgUrl(), MIMEType.JPG, false);
                    UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)result.getFiles().get(0);
                    this.saveToDb(result, mime);
                    String headImgUrlGsx = StorageUtil.constructUrl(uploadFile.getFid(), uploadFile.getSn(), mime.getCode());
                    fans.setHeadImgUrlGsx(headImgUrlGsx);
                }
                catch (Exception e) {
                    log.warn("fansPretreatment - headImgUrlGsx - exception:{}", (Throwable)e);
                }
            } else {
                fans.setHeadImgUrlGsx("");
            }
            try {
                this.fansDao.save((Object)fans, Boolean.valueOf(true), new String[0]);
            }
            catch (DuplicateKeyException ce) {
                fans = this.fansDao.getByOpenId(message.getFromUserName());
            }
            log.info("wechat - MessageReceiveServiceImpl - save fans - fans:{}", (Object)fans);
        } else if (message instanceof WechatOrdinaryMessage) {
            fans.setLastCommunicationTime(new Date());
            fans.setSubscribe(Integer.valueOf(1));
            log.info("wechat - MessageReceiveServiceImpl - WechatOrdinaryMessage - update fans - fans:{}", (Object)fans);
            this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
        } else if (message instanceof WechatEventMessage) {
            switch (((WechatEventMessage)message).getEvent()) {
                case SUBSCRIBE: {
                    if (fans.getSubscribe() == 1) break;
                    fans.setSubscribe(Integer.valueOf(1));
                    fans.setSubscribeTime(new Date());
                    log.info("wechat - MessageReceiveServiceImpl - SUBSCRIBE - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
                case UNSUBSCRIBE: {
                    fans.setSubscribe(Integer.valueOf(0));
                    log.info("wechat - MessageReceiveServiceImpl - UNSUBSCRIBE - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
                case LOCATION: {
                    WechatLocationEventMessage locationEventMessage = (WechatLocationEventMessage)message;
                    fans.setLongitude(locationEventMessage.getLongitude());
                    fans.setLatitude(locationEventMessage.getLatitude());
                    OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
                    if (orgAccount != null) {
                        CampusInfoDto findCloseOrgInfo = this.unifiedWechatAccountService.findCloseOrgInfo(orgAccount.getNumber().longValue(), fans.getLongitude(), fans.getLatitude());
                        fans.setDefaultOrgNumber(findCloseOrgInfo.getOrgNumber());
                    }
                    log.info("wechat - MessageReceiveServiceImpl - LOCATION - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
            }
        }
        return fans;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties((String)"mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"), mnsProperties.getProperty("mns.accesskeysecret"), mnsProperties.getProperty("mns.accountendpoint"));
            this.consultMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("consult.msg.queue"));
        }
        catch (Exception e) {
            log.error("init cloud account error:" + e);
        }
    }

    @Override
    public void pushConsultation(String orgNumber, String openId) {
    }

    String menuClick4FreeVersion(AuthorizerInfo authorizerInfo, WechatEventMessage message) {
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            FreeVersionMenuClick obj = FreeVersionMenuClick.getByKey(message.getEventKey());
            if (obj == null) {
                log.error("freeVersion unknown click key");
                return null;
            }
            List<Object> orgIds = new ArrayList();
            StringBuilder reply = new StringBuilder();
            WechatOpenIdEntityType entityType = null;
            switch (obj) {
                case STUDNET_CENTER: {
                    orgIds = this.wechatOpenIdRecordService.listOrgIdBy(authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), WechatOpenIdEntityType.STUDENT);
                    entityType = WechatOpenIdEntityType.STUDENT;
                    break;
                }
                case TEACHER_CENTER: {
                    orgIds = this.wechatOpenIdRecordService.listOrgIdBy(authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), WechatOpenIdEntityType.TEACHER);
                    entityType = WechatOpenIdEntityType.TEACHER;
                }
            }
            ArrayList<Integer> orgIdsInteger = new ArrayList<Integer>();
            for (Long longId : orgIds) {
                if (this.authorizationInfoDao.getByOrgId(Integer.valueOf(longId.intValue())) != null) continue;
                orgIdsInteger.add(longId.intValue());
            }
            if (CollectionUtils.isEmpty(orgIdsInteger)) {
                reply.append("\u4f60\u8fd8\u6ca1\u6709\u7ed1\u5b9a\u7684\u673a\u6784\u54e6\uff01\u53ef\u4ee5\u901a\u8fc7\u4ee5\u4e0b\u65b9\u5f0f\u7ed1\u5b9a\u673a\u6784\uff1a").append("\n").append("\u626b\u63cf\u673a\u6784\u7684\u4e8c\u7ef4\u7801\uff0c\u6216\u76f4\u63a5\u5728\u5bf9\u8bdd\u6846\u4e2d\u8f93\u5165\u673a\u6784\u7684\u5929\u6821\u53f7\u5c31\u53ef\u4ee5\u4e86\uff01");
            } else {
                List orgInfos = this.orgInfoDao.getOrgInfos(orgIdsInteger, new String[0]);
                List<OrgCenterInfo> list = OrgCenterInfo.convertBy(authorizerInfo.getAuthorizerAppId(), orgInfos, entityType);
                if (CollectionUtils.isNotEmpty(list)) {
                    reply.append("\u60f3\u8981\u67e5\u770b\u54ea\u4e2a\u673a\u6784,\u70b9\u51fb\u673a\u6784\u540d\u79f0\u76f4\u63a5\u8bbf\u95ee");
                }
                boolean useShortUrl = false;
                String url = null;
                if (list.size() > 1) {
                    useShortUrl = true;
                }
                for (OrgCenterInfo cInfo : list) {
                    url = useShortUrl ? ShortUrlUtil.getShortUrl((String)cInfo.getUrl()) : cInfo.getUrl();
                    reply.append("\n\n").append(this.getHrefLink(url, cInfo.getOrgShortName()));
                }
            }
            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), reply.toString());
        }
        return null;
    }

    String txNumerReply4FreeVersion(AuthorizerInfo authorizerInfo, WechatTextMessage message) {
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            String keywordReply = this.getKeywordReply(message, authorizerInfo, null);
            if (keywordReply != null) {
                return keywordReply;
            }
            if (!message.getContent().contains("\\.") && NumberUtils.isNumber((String)message.getContent())) {
                OrgInfo orgInfo = this.orgInfoDao.getByExtension(message.getContent(), new String[0]);
                if (orgInfo != null && this.freeVersionService.isFreeAccount(orgInfo.getOrgId())) {
                    OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgInfo.getOrgId(), new String[0]);
                    String url = OrgCenterInfo.getCenterSelectUrl(org.getId().longValue(), authorizerInfo.getAuthorizerAppId());
                    return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), orgInfo.getShortName() + ": \u9700\u8981\u60a8\u5b8c\u5584\u4e00\u4e0b\u4fe1\u606f\u54e6!", "", WechatProperties.getOrgCenterImg(), url);
                }
                return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), "\u673a\u6784\u4e0d\u5b58\u5728\u3002 \u8bf7\u6838\u5bf9\u673a\u6784\u5929\u6821\u53f7\u540e\u91cd\u65b0\u8f93\u5165,\u6216\u626b\u7801\u5173\u6ce8\u3002");
            }
            return this.generateDefaultResponse();
        }
        return null;
    }

    String orgIdQrCodeReply4FreeVersion(AuthorizerInfo authorizerInfo, WechatEventMessage message, Integer orgId) {
        if (this.freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
            if (orgInfo != null && this.freeVersionService.isFreeAccount(orgInfo.getOrgId())) {
                OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgInfo.getOrgId(), new String[0]);
                String url = OrgCenterInfo.getCenterSelectUrl(org.getId().longValue(), authorizerInfo.getAuthorizerAppId());
                return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), orgInfo.getShortName() + ": \u9700\u8981\u60a8\u5b8c\u5584\u4e00\u4e0b\u4fe1\u606f\u54e6!", "", WechatProperties.getOrgCenterImg(), url);
            }
            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), "\u673a\u6784\u4e0d\u5b58\u5728\u3002 \u8bf7\u6838\u5bf9\u673a\u6784\u5929\u6821\u53f7\u540e\u91cd\u65b0\u8f93\u5165,\u6216\u626b\u7801\u5173\u6ce8\u3002");
        }
        return null;
    }

    static class ReplyResultStatus {
        private boolean isAuthReply;
        private String replyContent;

        public boolean isAuthReply() {
            return this.isAuthReply;
        }

        public String getReplyContent() {
            return this.replyContent;
        }

        public void setAuthReply(boolean isAuthReply) {
            this.isAuthReply = isAuthReply;
        }

        public void setReplyContent(String replyContent) {
            this.replyContent = replyContent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplyResultStatus)) {
                return false;
            }
            ReplyResultStatus other = (ReplyResultStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAuthReply() != other.isAuthReply()) {
                return false;
            }
            String this$replyContent = this.getReplyContent();
            String other$replyContent = other.getReplyContent();
            return !(this$replyContent == null ? other$replyContent != null : !this$replyContent.equals(other$replyContent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReplyResultStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAuthReply() ? 79 : 97);
            String $replyContent = this.getReplyContent();
            result = result * 59 + ($replyContent == null ? 43 : $replyContent.hashCode());
            return result;
        }

        public String toString() {
            return "MessageReceiveServiceImpl.ReplyResultStatus(isAuthReply=" + this.isAuthReply() + ", replyContent=" + this.getReplyContent() + ")";
        }
    }
}

