/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncType;
import com.baijia.tianxiao.dal.wechat.constant.WechatMediaNewsType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMediaNewsDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatDataSyncLog;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMediaNews;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import com.baijia.tianxiao.sal.wechat.api.WechatDataSyncLogService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaNewsDto;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaUploadResultDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.PermanentMediaApiDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.task.MediaNewsSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediaServiceImpl
implements MediaService {
    private static final Logger log = LoggerFactory.getLogger(MediaServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgWechatMediaNewsDao orgWechatMediaNewsDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private WechatDataSyncLogService wechatDataSyncLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean redisMediaSyncInterval(String appId) {
        String key = String.format("tx_wechat_media_interval_%s", appId);
        Long intervalSeconds = 5L;
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB().intValue());
            if (connection.exists(key.getBytes()).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            connection.setEx(key.getBytes(), intervalSeconds.longValue(), "".getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Wechat - redisFansSyncInterval - exception - e:{}", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isNeedToSync(int orgId) {
        try {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
            if (this.wechatDataSyncLogService.hasTaskOngoing(authorizerInfo.getAuthorizerAppId(), WechatDataSyncType.MEDIA_NEWS)) {
                log.info("wechat media - isNeedToSync - RETURN FALSE - orgId:{}", (Object)orgId);
                return false;
            }
            if (!this.redisMediaSyncInterval(authorizerInfo.getAuthorizerAppId())) {
                log.info("wechat media - isNeedToSync - RETURN FALSE - orgId:{}", (Object)orgId);
                return false;
            }
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA, true);
            int mediaCount = this.orgWechatMediaNewsDao.count(authorizationInfo.getAuthorizerAppId());
            WechatApiResponse response = WechatMediaApiHelper.batchGetPermanentMediaNews(authorizationInfo.getAuthorizerAccessToken(), 0, 20);
            JSONObject rootNode = response.getRootJSONObj();
            if (mediaCount != rootNode.optInt("total_count", 0)) {
                log.info("wechat media - isNeedToSync - RETURN TRUE - orgId:{}", (Object)orgId);
                return true;
            }
        }
        catch (BussinessException | WechatException e) {
            log.warn("wechat media - isNeedToSync - CustomException", e);
        }
        catch (Exception e) {
            log.error("wechat media - isNeedToSync - Exception", (Throwable)e);
        }
        log.info("wechat media - isNeedToSync - RETURN FALSE - orgId:{}", (Object)orgId);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncMediaNews(String authorizerAppId) {
        Date now;
        log.info("wechat - MediaServiceImpl - mediaNewsSync - start - authorizerAppId:{}", (Object)authorizerAppId);
        Date startTime = now = new Date();
        Integer amountExpected = 0;
        Integer amountCompleted = 0;
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerAppId);
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        int count = WechatMediaApiHelper.countPermanentMedia(accessToken).getNewsCount();
        if (this.wechatDataSyncLogService.hasTaskOngoing(authorizerAppId, WechatDataSyncType.MEDIA_NEWS)) {
            log.info("wechat - MediaService - syncMediaNews - return - authorizerAppId:{}", (Object)authorizerAppId);
            return;
        }
        now = new Date();
        amountExpected = count;
        Date syncLogExpireTime = new Date(now.getTime() + (long)(amountExpected * 500));
        WechatDataSyncStatus syncLogEndStatus = WechatDataSyncStatus.END_SUCCESS;
        OrgWechatDataSyncLog syncLog = this.wechatDataSyncLogService.buildDefaultLog(authorizerAppId, WechatDataSyncType.MEDIA_NEWS, startTime, amountExpected, syncLogExpireTime);
        try {
            int i;
            Map oldMediaNewsMap = this.orgWechatMediaNewsDao.mapKeyMediaIdValueWechatUpdateTime(authorizerAppId);
            HashMap<String, OrgWechatMediaNews> newMediaNewsMap = new HashMap<String, OrgWechatMediaNews>();
            int num = 0;
            int pageSize = 20;
            int start = 0;
            ArrayList<OrgWechatMediaNews> mediaNewsToAdd = new ArrayList<OrgWechatMediaNews>();
            while (num < count) {
                WechatApiResponse response = null;
                try {
                    response = WechatMediaApiHelper.batchGetPermanentMediaNews(accessToken, start, start + pageSize);
                }
                catch (WechatException e) {
                    if (e.getErrorCode() == SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID) {
                        accessToken = this.authorizationInfoService.forceRefreshAccessToken(authorizationInfo.getOrgId()).getAuthorizerAccessToken();
                        response = WechatMediaApiHelper.batchGetPermanentMediaNews(accessToken, start, start + pageSize);
                    }
                    log.error("wechat - MediaServiceImpl - mediaNewsSync - batchGetPermanentMediaNews WechatException(all fail) - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                    throw e;
                }
                catch (WebServiceException e) {
                    log.warn("wechat - MediaServiceImpl - mediaNewsSync - batchGetPermanentMediaNews Exception - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                    continue;
                }
                catch (Exception e) {
                    log.error("wechat - MediaServiceImpl - mediaNewsSync - batchGetPermanentMediaNews Exception - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                    continue;
                }
                JSONObject rootNode = response.getRootJSONObj();
                count = rootNode.optInt("total_count", 0);
                num += rootNode.optInt("item_count", 0);
                JSONArray mediaNewsArray = rootNode.getJSONArray("item");
                if (mediaNewsArray.size() > 0) {
                    for (i = 0; i < mediaNewsArray.size(); ++i) {
                        OrgWechatMediaNews mediaNews = new OrgWechatMediaNews();
                        JSONObject mediaNewsJson = mediaNewsArray.getJSONObject(i);
                        JSONObject contentJson = mediaNewsJson.getJSONObject("content");
                        String mediaId = mediaNewsJson.getString("media_id");
                        Date wechatUpdateTime = new Date(mediaNewsJson.getLong("update_time"));
                        if (oldMediaNewsMap.get(mediaId) == null || ((Date)oldMediaNewsMap.get(mediaId)).getTime() / 1000L != wechatUpdateTime.getTime() / 1000L) {
                            mediaNews.setAuthorizerAppId(authorizerAppId);
                            mediaNews.setMediaId(mediaId);
                            mediaNews.setWechatUpdateTime(wechatUpdateTime);
                            JSONArray newsItemArray = contentJson.getJSONArray("news_item");
                            if (newsItemArray.size() > 0) {
                                for (int j = 0; j < newsItemArray.size(); ++j) {
                                    JSONObject mediaItem = newsItemArray.getJSONObject(j);
                                    mediaItem.put((Object)"content", null);
                                    String thumbMediaId = mediaItem.getString("thumb_media_id");
                                    if (StringUtils.isNotBlank((CharSequence)thumbMediaId)) {
                                        File localFile = null;
                                        try {
                                            byte[] data = WechatMediaApiHelper.downloadPermanentMedia(authorizationInfo.getAuthorizerAccessToken(), thumbMediaId);
                                            localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                                            UploadResult result = FileUploadUtils.uploadToRemote(Long.parseLong(authorizationInfo.getOrgId() + ""), localFile, false);
                                            mediaItem.put((Object)"thumb_media_url", (Object)((UploadResult.UploadFile)result.getFiles().get(0)).getUrl());
                                            if (localFile == null) continue;
                                        }
                                        catch (Exception e) {
                                            try {
                                                mediaItem.put((Object)"thumb_media_url", (Object)"");
                                                if (localFile == null) continue;
                                            }
                                            catch (Throwable throwable) {
                                                if (localFile != null) {
                                                    LocalFileHelper.deleteFile(localFile);
                                                }
                                                throw throwable;
                                            }
                                            LocalFileHelper.deleteFile(localFile);
                                            continue;
                                        }
                                        LocalFileHelper.deleteFile(localFile);
                                        continue;
                                    }
                                    mediaItem.put((Object)"thumb_media_url", (Object)"");
                                }
                                mediaNews.setJson(newsItemArray.toString());
                            } else {
                                mediaNews.setJson("[]");
                            }
                            if (oldMediaNewsMap.get(mediaId) == null) {
                                mediaNews.setCreateTime(now);
                                mediaNews.setUpdateTime(now);
                                mediaNews.setType(Integer.valueOf(WechatMediaNewsType.NORMAL.getValue()));
                                mediaNewsToAdd.add(mediaNews);
                            } else {
                                OrgWechatMediaNews news = this.orgWechatMediaNewsDao.getByMediaId(authorizerAppId, mediaId);
                                if (!news.getWechatUpdateTime().equals(wechatUpdateTime)) {
                                    news.setJson(mediaNews.getJson());
                                    news.setWechatUpdateTime(wechatUpdateTime);
                                    news.setUpdateTime(now);
                                    this.orgWechatMediaNewsDao.update((Object)news, Boolean.valueOf(true), new String[0]);
                                }
                            }
                        }
                        newMediaNewsMap.put(mediaId, mediaNews);
                    }
                }
                start += pageSize;
            }
            ArrayList<String> mediaIdsToDel = new ArrayList<String>();
            for (String mediaId : oldMediaNewsMap.keySet()) {
                if (newMediaNewsMap.get(mediaId) != null) continue;
                mediaIdsToDel.add(mediaId);
            }
            if (mediaIdsToDel.size() > 0) {
                this.orgWechatMediaNewsDao.delByMediaIds(authorizerAppId, mediaIdsToDel);
            }
            int batchNum = 20;
            if (mediaNewsToAdd.size() > 0) {
                ArrayList<Object> list = new ArrayList<OrgWechatMediaNews>();
                for (i = 0; i < mediaNewsToAdd.size(); ++i) {
                    list.add((OrgWechatMediaNews)mediaNewsToAdd.get(i));
                    if ((i == 0 || i % batchNum != 0) && i != mediaNewsToAdd.size() - 1) continue;
                    try {
                        this.batchSaveMediaNews(list);
                    }
                    catch (Exception e) {
                        log.warn("wechat - MediaServiceImpl - media batch insert fail", (Throwable)e);
                    }
                    list = new ArrayList();
                }
            }
            log.info("wechat - MediaServiceImpl - mediaNewsSync - end - authorizerAppId:{}", (Object)authorizerAppId);
        }
        catch (Exception e) {
            syncLogEndStatus = WechatDataSyncStatus.END_FAIL;
            throw e;
        }
        finally {
            now = new Date();
            syncLog.setStatus(Integer.valueOf(syncLogEndStatus.getValue()));
            syncLog.setAmountCompleted(amountExpected);
            syncLog.setStartTime(startTime);
            syncLog.setEndTime(now);
            syncLog.setUpdateTime(now);
            this.wechatDataSyncLogService.saveOrUpdateInNewTransaction(syncLog);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<MediaNewsDto> listPermanentMediaNews(int orgId, PageDto pageDto) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(Integer.valueOf(orgId));
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA, true);
        if (pageDto.getPageNum() == 1) {
            this.defaultMediaNews(orgId, authorizerInfo.getAuthorizerAppId());
            if (this.isNeedToSync(orgId)) {
                try {
                    log.info("wechat - listPermanentMediaNews - handle - add mediaNewsSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
                    TaskHelper.getInstance().addTask(new MediaNewsSyncJob(this, authorizerInfo.getAuthorizerAppId(), this.authorizerInfoService));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        String authorizerAppId = authorizerInfo.getAuthorizerAppId();
        Integer count = this.orgWechatMediaNewsDao.count(authorizerAppId);
        List mediaNewsList = null;
        mediaNewsList = count > 0 ? this.orgWechatMediaNewsDao.search(authorizerAppId, pageDto) : new ArrayList();
        pageDto.setCurPageCount(Integer.valueOf(mediaNewsList.size()));
        pageDto.setCount(count);
        ArrayList<MediaNewsDto> dtoList = new ArrayList<MediaNewsDto>();
        if (mediaNewsList != null && !mediaNewsList.isEmpty()) {
            for (OrgWechatMediaNews mediaNews : mediaNewsList) {
                MediaNewsDto dto = new MediaNewsDto();
                dto.setId(mediaNews.getId());
                dto.setMediaId(mediaNews.getMediaId());
                dto.setNewsItem(JSONArray.fromObject((Object)mediaNews.getJson()));
                dto.setWechatUpdateTime(mediaNews.getWechatUpdateTime().getTime());
                dto.setUpdateTime(mediaNews.getUpdateTime().getTime());
                dto.setCreateTime(mediaNews.getCreateTime().getTime());
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    @Override
    @Transactional(readOnly=true)
    public MediaNewsDto getPermanentMediaNews(int orgId, String mediaId) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        OrgWechatMediaNews mediaNews = this.orgWechatMediaNewsDao.getByMediaId(authorizationInfo.getAuthorizerAppId(), mediaId);
        MediaNewsDto dto = null;
        if (mediaNews != null) {
            dto = new MediaNewsDto();
            dto.setId(mediaNews.getId());
            dto.setMediaId(mediaNews.getMediaId());
            dto.setNewsItem(JSONArray.fromObject((Object)mediaNews.getJson()));
            dto.setWechatUpdateTime(mediaNews.getWechatUpdateTime().getTime());
            dto.setUpdateTime(mediaNews.getUpdateTime().getTime());
            dto.setCreateTime(mediaNews.getCreateTime().getTime());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MediaUploadResultDto uploadPermanentMediaImage(int orgId, String imageUrl, File imageFile) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA);
        PermanentMediaApiDto dto = WechatMediaApiHelper.uploadPermanentMediaImage(authorizationInfo.getAuthorizerAccessToken(), imageFile);
        MediaUploadResultDto result = new MediaUploadResultDto();
        result.setMediaId(dto.getMediaId());
        result.setMediaType(MediaType.IMAGE.getValue());
        result.setUrl(imageUrl);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MediaUploadResultDto uploadPermanentMediaImage(int orgId, String imageUrl) throws Exception {
        MediaUploadResultDto mediaUploadResultDto;
        block9: {
            File localFile = null;
            try {
                String extension = "jpg";
                if (imageUrl.contains("wx_fmt=")) {
                    Matcher matcher = Pattern.compile("wx_fmt=([^&]*)").matcher(imageUrl);
                    if (matcher.find()) {
                        extension = matcher.group(1);
                    }
                } else if (imageUrl.contains("\\.")) {
                    String[] temp = imageUrl.split("\\.");
                    extension = temp[temp.length - 1];
                }
                byte[] data = HttpClientUtils.download((String)imageUrl);
                localFile = LocalFileHelper.saveToLocal(data, extension);
                mediaUploadResultDto = this.uploadPermanentMediaImage(orgId, imageUrl, localFile);
                if (localFile == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw throwable;
                }
            }
            LocalFileHelper.deleteFile(localFile);
        }
        return mediaUploadResultDto;
    }

    @Override
    public MediaUploadResultDto uploadPermanentMediaNews(int orgId, String json) throws Exception {
        return this.uploadPermanentMediaNews(orgId, json, WechatMediaNewsType.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaUploadResultDto uploadPermanentMediaNews(int orgId, String json, WechatMediaNewsType type) throws Exception {
        PermanentMediaApiDto dto = null;
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        try {
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA);
            dto = WechatMediaApiHelper.uploadPermanentNews(authorizationInfo.getAuthorizerAccessToken(), json);
            MediaUploadResultDto result = new MediaUploadResultDto();
            result.setMediaId(dto.getMediaId());
            result.setMediaType(MediaType.NEWS.getValue());
            WechatApiResponse response = WechatMediaApiHelper.getPermanentMediaNews(authorizationInfo.getAuthorizerAccessToken(), dto.getMediaId());
            JSONArray newsItemArray = response.getRootJSONObj().getJSONArray("news_item");
            OrgWechatMediaNews mediaNews = new OrgWechatMediaNews();
            Date now = new Date();
            mediaNews.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            mediaNews.setMediaId(dto.getMediaId());
            mediaNews.setWechatUpdateTime(now);
            mediaNews.setCreateTime(now);
            mediaNews.setUpdateTime(now);
            for (int j = 0; j < newsItemArray.size(); ++j) {
                JSONObject mediaItem = newsItemArray.getJSONObject(j);
                mediaItem.put((Object)"content", null);
                String thumbMediaId = mediaItem.getString("thumb_media_id");
                if (StringUtils.isNotBlank((CharSequence)thumbMediaId)) {
                    File localFile = null;
                    try {
                        byte[] data = WechatMediaApiHelper.downloadPermanentMedia(authorizationInfo.getAuthorizerAccessToken(), thumbMediaId);
                        localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                        UploadResult uploadResult = FileUploadUtils.uploadToRemote(Long.parseLong(authorizationInfo.getOrgId() + ""), localFile, false);
                        mediaItem.put((Object)"thumb_media_url", (Object)((UploadResult.UploadFile)uploadResult.getFiles().get(0)).getUrl());
                        if (localFile == null) continue;
                    }
                    catch (Exception e) {
                        try {
                            mediaItem.put((Object)"thumb_media_url", (Object)"");
                            if (localFile == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (localFile != null) {
                                LocalFileHelper.deleteFile(localFile);
                            }
                            throw throwable;
                        }
                        LocalFileHelper.deleteFile(localFile);
                        continue;
                    }
                    LocalFileHelper.deleteFile(localFile);
                    continue;
                }
                mediaItem.put((Object)"thumb_media_url", (Object)"");
            }
            mediaNews.setJson(newsItemArray.toString());
            mediaNews.setType(Integer.valueOf(type.getValue()));
            this.orgWechatMediaNewsDao.save((Object)mediaNews, new String[0]);
            return result;
        }
        catch (Exception e) {
            log.warn("e:{}", (Throwable)e);
            if (dto != null) {
                try {
                    WechatMediaApiHelper.delPermanentMediaNews(authorizationInfo.getAuthorizerAccessToken(), dto.getMediaId());
                }
                catch (Exception e1) {
                    log.warn("e1:{}", (Throwable)e1);
                }
            }
            throw e;
        }
    }

    @Override
    public void delMedia(Integer orgId, String mediaId) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        WechatMediaApiHelper.delPermanentMediaNews(authorizationInfo.getAuthorizerAccessToken(), mediaId);
        this.orgWechatMediaNewsDao.delByMediaId(mediaId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void batchSaveMediaNews(List<OrgWechatMediaNews> list) {
        this.orgWechatMediaNewsDao.saveAll(list, false, new String[0]);
    }

    public void defaultMediaNews(int orgId, String authorizerAppId) {
        List mediaNews = this.orgWechatMediaNewsDao.getByAppIdAndType(authorizerAppId, WechatMediaNewsType.BUILTIN.getValue());
        if (CollectionUtils.isEmpty((Collection)mediaNews)) {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId), new String[0]);
            try {
                MediaUploadResultDto dto = this.uploadPermanentMediaImage(orgId, WechatProperties.getBuilitnMediaNewsImage());
                String content = HttpClientUtils.doGet((String)(WechatProperties.getWebCRMUrlPrefix() + "view/weixin/guide.html"), null);
                content = content.replace("#\u673a\u6784\u540d\u79f0#", orgInfo.getShortName());
                Pattern pattern = Pattern.compile("<img src=\"([^\"]*)");
                Matcher matcher = pattern.matcher(content);
                String imgSrc = null;
                String wechatImgSrc = null;
                while (matcher.find()) {
                    imgSrc = matcher.group(1);
                    wechatImgSrc = this.uploadPermanentMediaNewsImage(authorizationInfo.getAuthorizerAccessToken(), imgSrc);
                    content = content.replace(imgSrc, wechatImgSrc);
                }
                JSONObject json = new JSONObject();
                JSONArray articles = new JSONArray();
                JSONObject news = new JSONObject();
                news.put((Object)"thumb_media_id", (Object)dto.getMediaId());
                news.put((Object)"title", (Object)"\u65b0\u624b\u5f15\u5bfc");
                news.put((Object)"author", (Object)"\u5929\u6821");
                news.put((Object)"digest", (Object)"");
                news.put((Object)"show_cover_pic", (Object)"0");
                news.put((Object)"content", (Object)content);
                news.put((Object)"content_source_url", (Object)"");
                articles.add((Object)news);
                json.put((Object)"articles", (Object)articles);
                this.uploadPermanentMediaNews(orgId, json.toString(), WechatMediaNewsType.BUILTIN);
            }
            catch (Exception e) {
                log.warn("wechat - defalutMediaNews - exception", (Throwable)e);
            }
        } else if (mediaNews.size() > 0) {
            for (int i = 1; i < mediaNews.size(); ++i) {
                this.orgWechatMediaNewsDao.delById((Serializable)((OrgWechatMediaNews)mediaNews.get(i)).getId());
            }
        }
    }

    public String uploadPermanentMediaNewsImage(String accessToken, String imageUrl) throws Exception {
        String string;
        block13: {
            byte[] data;
            String extension;
            File localFile;
            block11: {
                String string2;
                block12: {
                    localFile = null;
                    extension = "jpg";
                    if (imageUrl.contains("wx_fmt=")) {
                        Matcher matcher = Pattern.compile("wx_fmt=([^&]*)").matcher(imageUrl);
                        if (matcher.find()) {
                            extension = matcher.group(1);
                        }
                    } else if (imageUrl.contains("\\.")) {
                        String[] temp = imageUrl.split("\\.");
                        extension = temp[temp.length - 1];
                    }
                    if (!imageUrl.startsWith("http")) {
                        imageUrl = "https:" + imageUrl;
                    }
                    log.info("data's length is :{} ", (data = HttpClientUtils.download((String)imageUrl)) == null ? "empty" : Integer.valueOf(data.length));
                    if (!GenericsUtils.isNullOrEmpty((Object)data)) break block11;
                    string2 = imageUrl;
                    if (localFile == null) break block12;
                    LocalFileHelper.deleteFile(localFile);
                }
                return string2;
            }
            try {
                localFile = LocalFileHelper.saveToLocal(data, extension);
                string = WechatMediaApiHelper.uploadPermanentMediaNewsImg(accessToken, localFile);
                if (localFile == null) break block13;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw throwable;
                }
            }
            LocalFileHelper.deleteFile(localFile);
        }
        return string;
    }
}

