/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.webauthlink;

import com.baijia.tianxiao.dto.smstoken.WechatSmsTokenDto;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatWebAuthLinkBuilder {
    private static final Logger log = LoggerFactory.getLogger(WechatWebAuthLinkBuilder.class);

    public static String fansinfo(WebAuthScope scope, String appId, String landingPage) {
        StringBuilder redirectUrl = new StringBuilder();
        try {
            redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("fansinfo.do?").append("&landingPage=").append(URLEncoder.encode(landingPage, "utf8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String studentCenter(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("personalCenter.do?");
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String studentCenter(WebAuthScope scope, String appId, Long orgId) {
        WechatSmsTokenDto dto = new WechatSmsTokenDto(Long.valueOf(orgId), appId);
        String sms_token = null;
        try {
            sms_token = dto.toTokenStr();
        }
        catch (Exception e) {
            log.error("toTokenStr error sms_token:{}", (Object)sms_token);
        }
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("personalCenter.do?").append("sms_token=").append(sms_token);
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String teacherCenter(WebAuthScope scope, String appId, Long orgId) {
        WechatSmsTokenDto dto = new WechatSmsTokenDto(Long.valueOf(orgId), appId);
        String sms_token = null;
        try {
            sms_token = dto.toTokenStr();
        }
        catch (Exception e) {
            log.error("toTokenStr error sms_token:{}", (Object)sms_token);
        }
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("teacherCenter.do?").append("sms_token=").append(sms_token);
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String teacherCenter(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("teacherCenter.do?");
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String schedule(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("schedule.do?");
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String mySigninRecord(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("signinRecord.do?");
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String rating(WebAuthScope scope, String appId) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("rating.do?");
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String customActivity(WebAuthScope scope, String appId, int activityId, int activityType, String relativePath) {
        StringBuilder landingPage = new StringBuilder();
        landingPage.append(WechatProperties.getWebMarketingUrlPrefix());
        landingPage.append(relativePath);
        landingPage.append("&activityId=").append(activityId);
        landingPage.append("&activityType=").append(activityType);
        return WechatWebAuthLinkBuilder.fansinfo(scope, appId, landingPage.toString());
    }

    public static String imSite(WebAuthScope scope, String appId, String sms_token) {
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(WechatProperties.getWebAuthUrlPrefix()).append("imsite.do?").append("&sms_token=").append(sms_token);
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }

    public static String wxIndex(WebAuthScope scope, String appId, String redirectUrl) {
        return WechatWebAuthLinkHelper.getWebAuthLink(appId, redirectUrl.toString(), scope);
    }
}

