/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.media;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaCountDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.PermanentMediaApiDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.TempMediaApiDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiCaller;
import java.io.File;
import net.sf.json.JSONObject;

public class WechatMediaApiHelper {
    public static TempMediaApiDto uploadTempMedia(String accessToken, MediaType type, File File2) throws WechatException, WebServiceException {
        WechatApiResponse response = WechatMediaApiCaller.uploadTempMedia(accessToken, type, File2);
        JSONObject rootNode = response.getRootJSONObj();
        TempMediaApiDto dto = new TempMediaApiDto();
        dto.setMediaId(rootNode.getString("media_id"));
        dto.setType(rootNode.getString("type"));
        dto.setCreatedAt(rootNode.getLong("created_at"));
        return dto;
    }

    public static byte[] downloadTempMedia(String accessToken, String mediaId) throws WechatException, WebServiceException, Exception {
        return WechatMediaApiCaller.downloadTempMedia(accessToken, mediaId);
    }

    public static WechatApiResponse uploadPermanentMedia(String accessToken, MediaType type, File file) {
        return WechatMediaApiCaller.uploadPermanentMedia(accessToken, type, file);
    }

    public static PermanentMediaApiDto uploadPermanentMediaImage(String accessToken, File file) {
        WechatApiResponse response = WechatMediaApiCaller.uploadPermanentMedia(accessToken, MediaType.IMAGE, file);
        JSONObject rootNode = response.getRootJSONObj();
        PermanentMediaApiDto dto = new PermanentMediaApiDto();
        dto.setMediaId(rootNode.getString("media_id"));
        dto.setUrl(rootNode.getString("url"));
        return dto;
    }

    public static PermanentMediaApiDto uploadPermanentNews(String accessToken, String json) {
        WechatApiResponse response = WechatMediaApiCaller.uploadPermanentNews(accessToken, json);
        JSONObject rootNode = response.getRootJSONObj();
        PermanentMediaApiDto dto = new PermanentMediaApiDto();
        dto.setMediaId(rootNode.getString("media_id"));
        return dto;
    }

    public static MediaCountDto countPermanentMedia(String accessToken) {
        MediaCountDto dto = new MediaCountDto();
        WechatApiResponse response = WechatMediaApiCaller.countPermanentMedia(accessToken);
        JSONObject rootNode = response.getRootJSONObj();
        dto.setImageCount(rootNode.optInt("image_count", 0));
        dto.setNewsCount(rootNode.optInt("news_count", 0));
        dto.setVideoCount(rootNode.optInt("video_count", 0));
        dto.setVoiceCount(rootNode.optInt("voice_count", 0));
        return dto;
    }

    public static WechatApiResponse batchGetPermanentMediaNews(String accessToken, int offset, int count) {
        return WechatMediaApiCaller.batchGetPermanentMedia(accessToken, MediaType.NEWS, offset, count);
    }

    public static WechatApiResponse getPermanentMediaNews(String accessToken, String mediaId) {
        return WechatMediaApiCaller.getPermanentMediaNews(accessToken, mediaId);
    }

    public static byte[] downloadPermanentMedia(String accessToken, String mediaId) throws Exception {
        return WechatMediaApiCaller.downloadPermanentMedia(accessToken, mediaId);
    }

    public static WechatApiResponse delPermanentMediaNews(String accessToken, String mediaId) {
        return WechatMediaApiCaller.delPermanentMediaNews(accessToken, mediaId);
    }

    public static String uploadPermanentMediaNewsImg(String accessToken, File file) {
        WechatApiResponse response = WechatMediaApiCaller.uploadPermanentMediaNewsImg(accessToken, file);
        JSONObject rootNode = response.getRootJSONObj();
        return rootNode.optString("url", "");
    }
}

