/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.tianxiao.sal.wechat.dto.menu.Button;
import com.baijia.tianxiao.sal.wechat.dto.menu.ClickButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.ComplexButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.MediaButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.Menu;
import com.baijia.tianxiao.sal.wechat.dto.menu.ViewButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.ViewLimitedButton;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuUtils {
    private static final Logger log = LoggerFactory.getLogger(MenuUtils.class);

    public static Menu covertJsonToMenu(String menuJson) {
        log.info("menuJson is : {}", (Object)menuJson);
        Menu menu = new Menu();
        JSONObject jsonObj = JSONObject.fromObject((Object)menuJson);
        JSONArray jsonArray = jsonObj.getJSONArray("button");
        Button[] createButtons = MenuUtils.createButtons(jsonArray);
        menu.addButton(createButtons);
        log.info("convert menuJson :{} to menu instance :{} ", (Object)menuJson, (Object)menu);
        return menu;
    }

    private static Button createButton(JSONObject next) {
        String type = null;
        if (next.get("type") != null) {
            type = next.getString("type");
        }
        boolean hasSubButton = GenericsUtils.isNullOrEmpty(type);
        Button button = null;
        if (hasSubButton) {
            button = new ComplexButton();
            button.setName(next.getString("name"));
            button.addSubButton(MenuUtils.createButtons(next.getJSONArray("sub_button")));
        } else if ("view".equals(type)) {
            button = MenuUtils.instanceButton(next.toString(), ViewButton.class);
        } else if ("click".equals(type)) {
            button = MenuUtils.instanceButton(next.toString(), ClickButton.class);
        } else if ("view_limited".equals(type)) {
            button = MenuUtils.instanceButton(next.toString(), ViewLimitedButton.class);
        } else if ("media_id".equals(type)) {
            button = MenuUtils.instanceButton(next.toString(), MediaButton.class);
        }
        return button;
    }

    private static <T> T instanceButton(String json, Class<T> clazz) {
        Gson gson = new Gson();
        Object fromJson = gson.fromJson(json, clazz);
        return (T)fromJson;
    }

    private static Button[] createButtons(JSONArray jsonArray) {
        ArrayList buttons = Lists.newArrayList();
        for (JSONObject next : jsonArray) {
            Button button = MenuUtils.createButton(next);
            buttons.add(button);
        }
        return buttons.toArray(new Button[buttons.size()]);
    }

    public static void compareAndSetCustomMenu(Menu needSetMenu, Menu customMenu) {
        log.info("needSetMenu is :{} ", (Object)needSetMenu);
        log.info("customMenu is :{} ", (Object)customMenu);
        List<Button> needSetButtons = needSetMenu.getButton();
        List<Object> customButtons = customMenu.getButton();
        List<Object> list = customButtons = GenericsUtils.isNullOrEmpty(customButtons) ? Lists.newArrayList() : customButtons;
        if (GenericsUtils.isNullOrEmpty(customMenu.getButton())) {
            customMenu.setButton((List<Button>)customButtons);
        }
        HashMap needSetSuperButtons = Maps.newHashMap();
        HashMap buttonResult = Maps.newHashMap();
        int i = 0;
        while (i < needSetButtons.size()) {
            Button buttonNeedSet = needSetButtons.get(i);
            needSetSuperButtons.put(buttonNeedSet.getName(), buttonNeedSet);
            for (Button button : customButtons) {
                MenuUtils.resetForComplexButton(buttonNeedSet, button, buttonResult);
            }
            ++i;
        }
        log.info("buttonResult is :{} ", (Object)buttonResult);
        HashMap customSuperButtons = Maps.newHashMap();
        int i2 = 0;
        while (i2 < customButtons.size()) {
            Button button = (Button)customButtons.get(i2);
            customSuperButtons.put(button.getName(), button);
            Button checkoutButton = MenuUtils.resetCustomMenuFromMap(button, buttonResult);
            customButtons.set(i2, checkoutButton);
            ++i2;
        }
        for (Map.Entry entry : needSetSuperButtons.entrySet()) {
            String key = (String)entry.getKey();
            if (customSuperButtons.get(key) != null || customSuperButtons.size() >= 3) continue;
            customButtons.add((Button)entry.getValue());
        }
    }

    private static Button resetCustomMenuFromMap(Button customButton, Map<String, Button> buttonResult) {
        if (customButton instanceof ComplexButton) {
            List<Button> sub_button = ((ComplexButton)customButton).getSub_button();
            int size = sub_button.size();
            int i = 0;
            while (i < size) {
                Button button_ = sub_button.get(i);
                Button checkoutButton = MenuUtils.resetCustomMenuFromMap(button_, buttonResult);
                sub_button.set(i, checkoutButton);
                ++i;
            }
            return customButton;
        }
        Button findNewButton = buttonResult.get(customButton.getName());
        if (findNewButton != null) {
            return findNewButton;
        }
        return customButton;
    }

    private static void resetForComplexButton(Button button, Button customButton, Map<String, Button> buttonResult) {
        if (button instanceof ComplexButton) {
            for (Button button_ : ((ComplexButton)button).getSub_button()) {
                MenuUtils.resetForComplexButton(button_, customButton, buttonResult);
            }
            return;
        }
        if (customButton instanceof ComplexButton) {
            for (Button button_ : ((ComplexButton)customButton).getSub_button()) {
                MenuUtils.resetForComplexButton(button, button_, buttonResult);
            }
            return;
        }
        String name1 = button.getName();
        String name2 = customButton.getName();
        log.info("name1 is :{} and name2 is:{} ", (Object)name1, (Object)name2);
        if (name1.equals(name2)) {
            buttonResult.put(name1, button);
        }
    }

    public void replaceWithNeedSet(List<Button> needSetButtons, List<Button> customButtons) {
        log.info("needSetButtons are : {} ", needSetButtons);
        log.info("customButtons are : {} ", customButtons);
        int i = 0;
        while (i < needSetButtons.size()) {
            String name = needSetButtons.get(i).getName();
            int j = i;
            boolean isMatch = false;
            int k = 0;
            while (k < customButtons.size()) {
                if (customButtons.get(k).getName().equals(name)) {
                    j = k;
                    isMatch = true;
                }
                ++k;
            }
            if (isMatch) {
                customButtons.set(j, needSetButtons.get(i));
            } else if (customButtons.size() <= i) {
                customButtons.add(needSetButtons.get(i));
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        String wechatMenuJson = "{'button':[{'type':'click','name':'\u4eca\u65e5\u6b4c\u66f2','key':'V1001_TODAY_MUSIC'},{'name':'\u83dc\u5355','sub_button':[{'type':'view','name':'\u641c\u7d22','url':'http://www.soso.com/'},{'type':'view','name':'\u89c6\u9891','url':'http://v.qq.com/'},{'type':'click','name':'\u8d5e\u4e00\u4e0b\u6211\u4eec','key':'V1001_GOOD'}]}]}";
        MenuUtils.covertJsonToMenu(wechatMenuJson);
    }
}

