/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtils.class);

    public static UploadResult uploadToRemote(Long uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();
        HashMap files = Maps.newHashMap();
        HashMap params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid", String.valueOf(WechatProperties.getUploadUidPrefix()) + uid);
        String url = WechatProperties.getUploadServer();
        if (watermark) {
            url = String.valueOf(url) + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles((String)url, (Map)params, (Map)files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", new Object[]{uid, file, response});
        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", (Object)uid, (Object)(end - start));
        UploadResult result = FileUploadUtils.parseResponse(response);
        if (result != null && result.getFiles() != null) {
            String fmt = "%s%s_%s.%s";
            for (UploadResult.UploadFile ufile : result.getFiles()) {
                String extension = file.getName().split("\\.")[1];
                String server = "";
                server = extension.equals(MIMEType.MP3.getExtension()) || extension.equals(MIMEType.AMR.getExtension()) ? WechatProperties.getFileServer() : WechatProperties.getImageServer();
                ufile.setUrl(String.format(fmt, server, ufile.getFid(), ufile.getSn(), extension));
            }
        }
        return result;
    }

    private static UploadResult parseResponse(String response) {
        if (StringUtils.isBlank((CharSequence)response)) {
            return null;
        }
        UploadResult uploadResult = null;
        try {
            JSONObject rootNode = JSONObject.fromObject((Object)response);
            uploadResult = new UploadResult();
            uploadResult.setFail(rootNode.getInt("fail"));
            uploadResult.setOk(rootNode.getInt("ok"));
            uploadResult.setTotal(rootNode.getInt("total"));
            JSONArray filesArray = rootNode.getJSONArray("files");
            if (filesArray != null && filesArray.size() > 0) {
                ArrayList<UploadResult.UploadFile> list = new ArrayList<UploadResult.UploadFile>();
                UploadResult.UploadFile uFile = null;
                JSONObject fileNode = null;
                int i = 0;
                while (i < filesArray.size()) {
                    uFile = new UploadResult.UploadFile(uploadResult);
                    fileNode = filesArray.getJSONObject(i);
                    uFile.setFid(fileNode.getString("fid"));
                    uFile.setKey(fileNode.getString("key"));
                    uFile.setSize(fileNode.getInt("size"));
                    uFile.setSn(fileNode.getString("sn"));
                    list.add(uFile);
                    ++i;
                }
                uploadResult.setFiles(list);
            }
        }
        catch (Exception e) {
            log.error("parse response :{} catch error:{}", (Object)response, (Object)e);
        }
        log.info("parseResponse - response:{}, uploadResult:{}", (Object)response, (Object)uploadResult);
        return uploadResult;
    }

    public static UploadResult uploadToRemote(Long uid, String url, MIMEType mime, boolean watermark) {
        UploadResult result;
        block8: {
            File localFile = null;
            result = null;
            byte[] data = null;
            try {
                try {
                    data = HttpClientUtils.download((String)url);
                    localFile = LocalFileHelper.saveToLocal(data, mime);
                    result = FileUploadUtils.uploadToRemote(uid, localFile, false);
                }
                catch (Exception e) {
                    log.error("uploadToRemote - exception", (Throwable)e);
                    log.error("uploadToRemote - url:{},dataisnull:{}", (Object)url, (Object)(data == null ? 1 : 0));
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (localFile != null) {
                    LocalFileHelper.deleteFile(localFile);
                }
                throw throwable;
            }
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
        }
        return result;
    }
}

