/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.task;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaNewsSyncJob
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MediaNewsSyncJob.class);
    private MediaService mediaService;
    private AuthorizerInfoService authorizerInfoService;
    private String authorizerAppId;

    public MediaNewsSyncJob(MediaService mediaService, String authorizerAppId, AuthorizerInfoService authorizerInfoService) {
        this.mediaService = mediaService;
        this.authorizerInfoService = authorizerInfoService;
        this.authorizerAppId = authorizerAppId;
    }

    @Override
    public void run() {
        block8: {
            log.info("Wechat - MediaNewsSyncJob - run - start - authorizerAppId:{}", (Object)this.authorizerAppId);
            AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByAuthorizerAppId(this.authorizerAppId);
            if (authorizerInfo.getMediaNewsSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()) {
                return;
            }
            authorizerInfo.setMediaNewsSyncStatus(Integer.valueOf(WechatDataSyncStatus.ONGOING.getValue()));
            this.authorizerInfoService.update(authorizerInfo);
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
                this.mediaService.syncMediaNews(this.authorizerAppId);
            }
            catch (WechatException e) {
                log.error("Wechat - MediaNewsSyncJob - WechatException - e:{}", (Throwable)e);
                authorizerInfo.setMediaNewsSyncStatus(Integer.valueOf(WechatDataSyncStatus.END_SUCCESS.getValue()));
                this.authorizerInfoService.update(authorizerInfo);
                break block8;
            }
            catch (Exception e) {
                try {
                    log.error("Wechat - MediaNewsSyncJob - Exception - e:{}", (Throwable)e);
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    authorizerInfo.setMediaNewsSyncStatus(Integer.valueOf(WechatDataSyncStatus.END_SUCCESS.getValue()));
                    this.authorizerInfoService.update(authorizerInfo);
                }
            }
            authorizerInfo.setMediaNewsSyncStatus(Integer.valueOf(WechatDataSyncStatus.END_SUCCESS.getValue()));
            this.authorizerInfoService.update(authorizerInfo);
        }
        log.info("Wechat - MediaNewsSyncJob - run - end authorizerAppId:{}", (Object)this.authorizerAppId);
    }
}

