/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import com.baijia.tianxiao.sal.wechat.api.WechatDataSyncService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.task.FansSyncJob;
import com.baijia.tianxiao.sal.wechat.task.MediaNewsSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WechatDataSyncServiceImpl
implements WechatDataSyncService {
    private static final Logger log = LoggerFactory.getLogger(WechatDataSyncServiceImpl.class);
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private FansService fansService;
    @Autowired
    private MediaService mediaService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncWechatData(Integer orgId) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByOrgId(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(orgId);
        if (authorizationInfo == null || authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        try {
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_LIST, true);
            log.info("wechat - WechatDataSyncServiceImpl - syncWechatData - add fansSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
            TaskHelper.getInstance().addTask(new FansSyncJob(this.fansService, authorizerInfo.getAuthorizerAppId()));
        }
        catch (Exception e) {
            log.warn("wechat - WechatDataSyncServiceImpl - syncWechatData - add fansSync task exception - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
            log.warn("", (Throwable)e);
        }
        try {
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA, true);
            log.info("wechat - WechatDataSyncServiceImpl - syncWechatData - add mediaNewsSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
            TaskHelper.getInstance().addTask(new MediaNewsSyncJob(this.mediaService, authorizerInfo.getAuthorizerAppId(), this.authorizerInfoService));
        }
        catch (Exception e) {
            log.warn("wechat - WechatDataSyncServiceImpl - syncWechatData - add mediaNewsSync task exception - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
            log.warn("", (Throwable)e);
        }
    }
}

