/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.qrcode;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrActivity;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrSubscribeOrg;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeCaller;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import java.io.File;
import net.sf.json.JSONObject;

public class WechatQRCodeLinkHelper {
    public static QRCodeDto getQRCodeDto(String accessToken) {
        WechatApiResponse response = WechatQRCodeCaller.createPermanentQRCode(accessToken, "");
        JSONObject rootNode = response.getRootJSONObj();
        QRCodeDto dto = new QRCodeDto();
        dto.setTicket(rootNode.getString("ticket"));
        dto.setUrl(rootNode.getString("url"));
        return dto;
    }

    public static QRCodeDto getQRCodeDtoForCustomActivity(String accessToken, int activityId, int activityType) {
        QRCodeSceneStrActivity activity = new QRCodeSceneStrActivity(activityId, activityType);
        WechatApiResponse response = WechatQRCodeCaller.createPermanentQRCode(accessToken, activity.getSceneStr().toString());
        JSONObject rootNode = response.getRootJSONObj();
        QRCodeDto dto = new QRCodeDto();
        dto.setTicket(rootNode.getString("ticket"));
        dto.setUrl(rootNode.getString("url"));
        return dto;
    }

    public static QRCodeDto getQRCodeDtoForCustomActivity(String accessToken, int originOrgId, int activityId, int activityType) {
        QRCodeSceneStrActivity activity = new QRCodeSceneStrActivity(activityId, activityType, originOrgId);
        WechatApiResponse response = WechatQRCodeCaller.createPermanentQRCode(accessToken, activity.getSceneStr().toString());
        JSONObject rootNode = response.getRootJSONObj();
        QRCodeDto dto = new QRCodeDto();
        dto.setTicket(rootNode.getString("ticket"));
        dto.setUrl(rootNode.getString("url"));
        return dto;
    }

    public static QRCodeDto getQRCodeDtoForSubscribeWithOrgId(String accessToken, Integer orgId) {
        QRCodeSceneStrSubscribeOrg qrCode = new QRCodeSceneStrSubscribeOrg(orgId);
        WechatApiResponse response = WechatQRCodeCaller.createPermanentQRCode(accessToken, qrCode.getSceneStr().toString());
        JSONObject rootNode = response.getRootJSONObj();
        QRCodeDto dto = new QRCodeDto();
        dto.setTicket(rootNode.getString("ticket"));
        dto.setUrl(rootNode.getString("url"));
        return dto;
    }

    public static byte[] downloadQRCodeImage(String ticket) throws WechatException, WebServiceException, Exception {
        return WechatQRCodeCaller.downloadQRCodeImage(ticket);
    }

    public static String getGsxImgUrl(QRCodeDto qrCodeDto) throws Exception {
        String qrCodeImgUrl;
        File localFile = null;
        try {
            byte[] data = WechatQRCodeLinkHelper.downloadQRCodeImage(qrCodeDto.getTicket());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
            UploadResult result = FileUploadUtils.uploadToRemote(Flag.NULL.getLong(), localFile, false);
            qrCodeImgUrl = ((UploadResult.UploadFile)result.getFiles().get(0)).getUrl();
        }
        catch (Throwable throwable) {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
            throw throwable;
        }
        if (localFile != null) {
            LocalFileHelper.deleteFile(localFile);
        }
        return qrCodeImgUrl;
    }
}

