/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.constant;

import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MediaType {
    UNKNOWN(0, "", "\u672a\u77e5", false, false),
    IMAGE(1, "image", "\u56fe\u7247", false, false),
    VOICE(2, "voice", "\u8bed\u97f3", false, false),
    VIDEO(3, "video", "\u89c6\u9891", false, false),
    THUMB(4, "thumb", "\u7f29\u7565\u56fe", false, false),
    NEWS(5, "news", "\u56fe\u6587\u7d20\u6750", false, false),
    CONTENT(6, "", "\u6587\u672c", false, false),
    ZIDINGYILIANJIE(15, "", "\u81ea\u5b9a\u4e49\u94fe\u63a5", true, false),
    WANGXIAOZHUYE(11, "", "\u7f51\u6821\u4e3b\u9875", true, false),
    KECHENGDANYE(12, "", "\u8bfe\u7a0b\u5355\u9875", true, false),
    HUODONG(13, "", "\u6d3b\u52a8", true, false),
    KECHENGLIEBIAO(14, "", "\u8bfe\u7a0b\u5217\u8868", true, false),
    WODEKEBIAO(16, "", "\u6211\u7684\u8bfe\u8868", true, true),
    WODEQIANDAO(17, "", "\u6211\u7684\u7b7e\u5230", true, true),
    WODEPINGJIA(18, "", "\u6211\u7684\u8bc4\u4ef7", true, true),
    WEIGUANWANG(19, "", "\u5fae\u5b98\u7f51", true, false),
    XIAOQUDIZHI(20, "", "\u6821\u533a\u5730\u5740", true, false),
    DIANHUA(21, "", "400\u7535\u8bdd", true, true, true){

        @Override
        public String getNote() {
            return "[_400\u7535\u8bdd]";
        }
    }
    ,
    ZAIXIANZIXUN(22, "", "\u5728\u7ebf\u54a8\u8be2", false, false, true),
    YUYUESHITING(23, "", "\u9884\u7ea6\u8bd5\u542c", true, false),
    GERENZHONGXIN(24, "", "\u4e2a\u4eba\u4e2d\u5fc3", true, true),
    XUESHENGZHONGXIN(25, "", "\u5b66\u751f\u4e2d\u5fc3", true, true),
    LAOSHIZHONGXIN(26, "", "\u8001\u5e08\u4e2d\u5fc3", true, true);

    private static final Logger log;
    private int value;
    private String str;
    private String label;
    private boolean needUrl;
    private boolean webauth;
    private boolean canSetToUnifiedWechat;

    static {
        log = LoggerFactory.getLogger(MediaType.class);
    }

    public static MediaType getByVaule(int value) {
        MediaType[] mediaTypeArray = MediaType.values();
        int n = mediaTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType type = mediaTypeArray[n2];
            if (type.getValue() == value) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static MediaType getByLabel(String label) {
        MediaType[] mediaTypeArray = MediaType.values();
        int n = mediaTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType type = mediaTypeArray[n2];
            if (type.getLabel().equals(label)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    private MediaType(int value, String str, String label, boolean needUrl, boolean webauth) {
        this(value, str, label, needUrl, webauth, false);
    }

    private MediaType(int value, String str, String label, boolean needUrl, boolean webauth, boolean canSetToUnifiedWechat) {
        this.value = value;
        this.str = str;
        this.label = label;
        this.webauth = webauth;
        this.canSetToUnifiedWechat = canSetToUnifiedWechat;
    }

    public int getValue() {
        return this.value;
    }

    public String getStr() {
        return this.str;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isNeedUrl() {
        return this.needUrl;
    }

    public void setNeedUrl(boolean needUrl) {
        this.needUrl = needUrl;
    }

    public boolean isWebauth() {
        return this.webauth;
    }

    public boolean isCanSetToUnifiedWechat() {
        return this.canSetToUnifiedWechat;
    }

    public void setWebauth(boolean webauth) {
        this.webauth = webauth;
    }

    public String getNote() {
        String fmt = "[%s]";
        return String.format(fmt, this.label);
    }

    public String getUrl(OrgWechatDto orgWechatDto) {
        switch (this) {
            case WANGXIAOZHUYE: {
                String wangXiaoZhuYe = this.createCampusWangxiaoZhuYeUrl(orgWechatDto);
                if (orgWechatDto.isUnifiedWechatAccount()) {
                    wangXiaoZhuYe = WechatWebAuthLinkBuilder.wxIndex(WebAuthScope.BASE, orgWechatDto.getAppId(), wangXiaoZhuYe);
                }
                return wangXiaoZhuYe;
            }
            case KECHENGLIEBIAO: {
                return this.createCampusCourseListUrl(orgWechatDto);
            }
            case WODEKEBIAO: {
                return WechatWebAuthLinkBuilder.schedule(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case WODEQIANDAO: {
                return WechatWebAuthLinkBuilder.mySigninRecord(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case WODEPINGJIA: {
                return WechatWebAuthLinkBuilder.rating(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case XUESHENGZHONGXIN: {
                return WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case LAOSHIZHONGXIN: {
                return WechatWebAuthLinkBuilder.teacherCenter(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case XIAOQUDIZHI: {
                return this.createCampusLocatioinUrl(orgWechatDto);
            }
            case YUYUESHITING: {
                return this.createCampusYuYueShiTing(orgWechatDto);
            }
            case DIANHUA: {
                return this.createCapmusListUrl(orgWechatDto);
            }
            case ZAIXIANZIXUN: {
                return this.createZaixianZiXun(orgWechatDto);
            }
        }
        return null;
    }

    public String createZaixianZiXun(OrgWechatDto orgWechatDto) {
        if (orgWechatDto.isUnifiedWechatAccount()) {
            return this.createCapmusListUrl(orgWechatDto);
        }
        return "";
    }

    public String createCampusYuYueShiTing(OrgWechatDto orgWechatDto) {
        String fmt4 = "%s%s?orgNumber=%s";
        return String.format(fmt4, WechatProperties.getWebCRMUrlPrefix(), "consult/view.do", orgWechatDto.getOrgNumber());
    }

    public String createCampusWangxiaoZhuYeUrl(OrgWechatDto orgWechatDto) {
        log.info("orgWechatDto is :{} -- createCampusWangxiaoZhuYeUrl", (Object)orgWechatDto);
        if (orgWechatDto.isUnifiedWechatAccount()) {
            StringBuilder mHostBuilder = new StringBuilder(WechatProperties.getWebMTianXiaoUrlPrefix());
            mHostBuilder.append(String.format(WechatProperties.getMhostURLFormat(), orgWechatDto.getOrgNumber()));
            String mHost = mHostBuilder.toString().toString();
            log.info("find http :{} ", (Object)mHost);
            if (!mHost.startsWith("https") && !mHost.contains("test-tianxiao100-m.ctest.baijiahulian.com")) {
                log.info("find http :{} ", (Object)mHost);
                mHost = mHost.replace("http", "https");
            }
            return mHost;
        }
        String fmt1 = "%s%s%s";
        return String.format(fmt1, WechatProperties.getWebMTianXiaoUrlPrefix(), "i/", orgWechatDto.getOrgNumber());
    }

    public String createCampusCourseListUrl(OrgWechatDto orgWechatDto) {
        log.info("orgWechatDto is :{} --createCampusCourseListUrl ", (Object)orgWechatDto);
        if (orgWechatDto.isUnifiedWechatAccount()) {
            String mTianxiaoHost = WechatProperties.getWebMTianXiaoUrlPrefix();
            log.info("mTianxiaoHost is :{} ", (Object)mTianxiaoHost);
            StringBuilder sbOfCourseList = new StringBuilder(mTianxiaoHost);
            sbOfCourseList.append(String.format(WechatProperties.getcampusCourseListUrlFormat(), orgWechatDto.getOrgNumber()));
            return sbOfCourseList.toString();
        }
        String fmt2 = "%s%s%s";
        return String.format(fmt2, WechatProperties.getWebMTianXiaoUrlPrefix(), "course/", orgWechatDto.getOrgNumber());
    }

    public String createCampusLocatioinUrl(OrgWechatDto orgWechatDto) {
        log.info("orgWechatDto is :{} --createCampusLocatioinUrl", (Object)orgWechatDto);
        if (orgWechatDto.isUnifiedWechatAccount()) {
            return this.createCapmusListUrl(orgWechatDto);
        }
        String fmt3 = "%s%s%s";
        String httpUrl = this.getMurlForXiaoqudizhi();
        return String.format(fmt3, httpUrl, "branch/", orgWechatDto.getOrgNumber());
    }

    private String getMurlForXiaoqudizhi() {
        String webMTianXiaoUrlPrefix = WechatProperties.getWebMTianXiaoUrlPrefix();
        if (webMTianXiaoUrlPrefix.startsWith("https:")) {
            return webMTianXiaoUrlPrefix.replace("https", "http");
        }
        return webMTianXiaoUrlPrefix;
    }

    public String createCapmusListUrl(OrgWechatDto orgWechatDto) {
        log.info("orgWechatDto is :{} --createCapmusListUrl", (Object)orgWechatDto);
        Integer orgNumber = orgWechatDto.getOrgNumber();
        String appId = orgWechatDto.getAppId();
        StringBuilder sb = new StringBuilder(this.getMurlForXiaoqudizhi());
        sb.append(String.format(WechatProperties.getCampusListUrlFormat(), orgNumber, appId));
        String campusListUrl = sb.toString();
        if (orgWechatDto.isUnifiedWechatAccount()) {
            campusListUrl = WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, appId, campusListUrl);
        }
        return campusListUrl;
    }

    public static String fillUrlWithHttp(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && !url.startsWith("http://")) {
            url = "http://" + url;
        }
        return url;
    }

    /* synthetic */ MediaType(String string, int n, int n2, String string2, String string3, boolean bl, boolean bl2, boolean bl3, MediaType mediaType) {
        this(n2, string2, string3, bl, bl2, bl3);
    }
}

