/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.validator;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;

/**   
 * @title       : ApiPermissionValidator 
 * @description : 微信接口调用权限判断
 * @author      : zhenyujian
 * @date        : 2016年1月3日 下午3:22:59 
 */
public class WechatApiValidator {
	
	
	public static void _4CallApi(AuthorizationInfo authorizationInfo,
								 AuthorizerInfo authorizerInfo,
								 WechatApi wechatApi,
								 boolean checkDataSync) throws BussinessException{
		if (authorizationInfo==null || authorizerInfo == null) {
			//不存在公众号的授权记录
        	throw new BussinessException(SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
		
		if(wechatApi==null){
			//api 不在已知的api权限列表中时 不行权限判断 允许直接调用
			return;
		}
		
		if(wechatApi.getPermission()!=null){
			if( !authorizationInfo.hasFunc(wechatApi.getPermission().getValue()) ){
				//公众号授予的权限列表不足
				throw new BussinessException(SalWechatErrorCode.WECHAT_AUTHORIZATION_DENIED);
			}
        	
        	//数据同步验证
//			if(checkDataSync){
//	    		switch(wechatApi.getPermission()){
//	    			case USER_MANAGE:
//	    				if(authorizerInfo.getFansSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()){
//	    					//粉丝列表同步中
//	    					throw new BussinessException(SalWechatErrorCode.WECHAT_DATA_IN_SYNC);
//	    				}
//	    				break;
//	    			case WECHAT_MEDIA:
//	    				if(authorizerInfo.getMediaNewsSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()){
//	    					//素材列表同步中
//	    					throw new BussinessException(SalWechatErrorCode.WECHAT_DATA_IN_SYNC);
//	    				}
//	    				break;
//	    			default:
//	    				break;
//	    		}
//			}
		}
		
		//接口访问权限判断
		if(authorizerInfo.isServiceApp()){
			//服务号
			if( authorizerInfo.isPassedVerify() && wechatApi.getVerifiedService()!=1 ){
				throw new BussinessException(SalWechatErrorCode.WECHAT_PERMISSION_DENIED);
			}else if( !authorizerInfo.isPassedVerify() && wechatApi.getUnverifiedService()!=1 ){
				throw new BussinessException(SalWechatErrorCode.WECHAT_PERMISSION_DENIED);
			}
		}else{
			//订阅号
			if( authorizerInfo.isPassedVerify() && wechatApi.getVerifiedSubscribe()!=1 ){
				throw new BussinessException(SalWechatErrorCode.WECHAT_PERMISSION_DENIED);
			}else if( !authorizerInfo.isPassedVerify() && wechatApi.getUnverifiedSubscribe()!=1 ){
				throw new BussinessException(SalWechatErrorCode.WECHAT_PERMISSION_DENIED);
			}
		}
	}
	
	
	
	public static void _4CallApi(AuthorizationInfo authorizationInfo,
								 AuthorizerInfo authorizerInfo,
								 WechatApi wechatApi) throws BussinessException{
		_4CallApi(authorizationInfo, authorizerInfo, wechatApi, false);
	}
	
}

