/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.Date;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncType;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatDataSyncLogDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatDataSyncLog;
import com.baijia.tianxiao.sal.wechat.api.WechatDataSyncLogService;



@Slf4j
@Service
public class WechatDataSyncLogServiceImpl implements WechatDataSyncLogService{
	
	@Autowired
	private OrgWechatDataSyncLogDao orgWechatDataSyncLogDao;
	
	@Override
	public boolean hasTaskOngoing(String authorizerAppId, WechatDataSyncType type) {
		
		if( orgWechatDataSyncLogDao.countOnGoingAndUnExpired(authorizerAppId, WechatDataSyncType.FANS) > 0){
			log.info("Wechat - hasTaskOngoing - run - stop by other task is ongoing - authorizerAppId:{}",authorizerAppId);
			return true;
		}
		return false;
	}

	
	
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Exception.class)
	@Override
	public void saveOrUpdateInNewTransaction(OrgWechatDataSyncLog dataSyncLog) {
		orgWechatDataSyncLogDao.saveOrUpdate(dataSyncLog);
	}



	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Exception.class)
	@Override
	public OrgWechatDataSyncLog buildDefaultLog(String authorizerAppId, WechatDataSyncType type, Date startTime, Integer amountExpected, Date expireTime) {
		OrgWechatDataSyncLog dataSyncLog = OrgWechatDataSyncLog.buildDefaultLog(authorizerAppId, WechatDataSyncType.FANS, startTime, amountExpected, expireTime);
		orgWechatDataSyncLogDao.saveOrUpdate(dataSyncLog);
		return dataSyncLog;
	}

	
}

