/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.BatchMsgService;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.batch.BatchMsgApiHelper;

/**
 * @Title : BatchMsgServiceImpl
 * @Description :群发消息
 * @Author : zhenyujian
 * @Date : 2015年12月3日 下午3:29:26
 */
@Slf4j
@Service
public class BatchMsgServiceImpl implements BatchMsgService {

    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    
    @Transactional(readOnly = true)
    @Override
    public void sendMediaNews(Integer orgId, String mediaId, Integer groupId){
    	AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(orgId);
    	log.info("wechat - BatchMsgServiceImpl - sendMediaNews - appdI:{},mediaId:{},groupId:{}", authorizationInfo.getAuthorizerAppId(), mediaId, groupId);
    	try{
    		BatchMsgApiHelper.sendMediaNews(authorizationInfo.getAuthorizerAccessToken(), mediaId, groupId);
    	}catch(WechatException e){
    		OrgAccount orgAccount = orgAccountDao.getById(orgId);
    		OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
    		log.error("微信提示: 首次使用群发功能前,请先登录微信公众平台在‘群发功能’中完成协议确认 orgId:{},name:{},mobile:{}", orgId, orgInfo.getShortName(), orgAccount.getMobile());
    		throw e;
    	}
    }
}
