/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.autoreply;

import com.baijia.tianxiao.util.date.DateUtil;

/**   
 * @title       : PassiveReplyMsgBuilder 
 * @description : 自动回复 (通过返回字符串形式 不需要任何权限)
 * 				  http://mp.weixin.qq.com/wiki/1/6239b44c206cab9145b1d52c67e6c551.html 
 * @author      : zhenyujian
 * @date        : 2016年1月13日 下午2:22:31 
 */
public class PassiveReplyMsgBuilder {

	
	/**
	 * @Description  : 文本消息
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月13日 下午2:36:17 
	 *
	 * @Return       : String
	 */
	public static String textMsg(String fromUser, String toUser, String content){
		long now = DateUtil.currentUnixTimestamp();
		String msgFmt = "<xml>"
						+ "<ToUserName><![CDATA[%s]]></ToUserName>"
						+ "<FromUserName><![CDATA[%s]]></FromUserName>"
						+ "<CreateTime>%d</CreateTime>"
						+ "<MsgType><![CDATA[text]]></MsgType>"
						+ "<Content><![CDATA[%s]]></Content>"
						+ "</xml>";
		
		return String.format(msgFmt, toUser, fromUser, now, content);
	}
	
	
	
	/**
	 * @Description  : 图片消息
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月13日 下午2:37:42 
	 *
	 * @Return       : String
	 */
	public static String imageMsg(String fromUser, String toUser, String mediaId){
		long now = DateUtil.currentUnixTimestamp();
		String msgFmt =   "<xml>"
						+ "<ToUserName><![CDATA[%s]]></ToUserName>"
						+ "<FromUserName><![CDATA[%s]]></FromUserName>"
						+ "<CreateTime>%s</CreateTime>"
						+ "<MsgType><![CDATA[image]]></MsgType>"
						+ "<Image>"
						+ "<MediaId><![CDATA[%s]]></MediaId>"
						+ "</Image>"
						+ "</xml>";
		
		return String.format(msgFmt, toUser, fromUser, now, mediaId);
	}
	
	
	/**
	 * @Description  : 语音消息 
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月13日 下午2:38:56 
	 *
	 * @Return       : String
	 */
	public static String voiceMsg(String fromUser, String toUser, String mediaId){
		long now = DateUtil.currentUnixTimestamp();
		String msgFmt =   "<xml>"
						+ "<ToUserName><![CDATA[%s]]></ToUserName>"
						+ "<FromUserName><![CDATA[%s]]></FromUserName>"
						+ "<CreateTime>%s</CreateTime>"
						+ "<MsgType><![CDATA[voice]]></MsgType>"
						+ "<Voice>"
						+ "<MediaId><![CDATA[%s]]></MediaId>"
						+ "</Voice>"
						+ "</xml>";
		
		return String.format(msgFmt, toUser, fromUser, now, mediaId);
	}
	
	
	
	public static String newsMsg(String fromUser, String toUser, String title, String desc, String imgUrl, String url){
		long now = DateUtil.currentUnixTimestamp();
		String msgFmt =   "<xml>"
						+ "<ToUserName><![CDATA[%s]]></ToUserName>"
						+ "<FromUserName><![CDATA[%s]]></FromUserName>"
						+ "<CreateTime>%s</CreateTime>"
						+ "<MsgType><![CDATA[news]]></MsgType>"
						+ "<ArticleCount>1</ArticleCount>"
						+ "<Articles>"
						+ "<item>"
						+ "<Title><![CDATA[%s]]></Title> "
						+ "<Description><![CDATA[%s]]></Description>"
						+ "<PicUrl><![CDATA[%s]]></PicUrl>"
						+ "<Url><![CDATA[%s]]></Url>"
						+ "</item>"
						+ "</Articles>"
						+ "</xml>";
		
		return String.format(msgFmt, toUser, fromUser, now, title, desc, imgUrl, url);
	}
	
}

