/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.courseupdate;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;

import net.sf.json.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**   
 * @title       : CourseStartNoticeMsg 
 * @description : 上课调整通知 - 学生
 * @author      : zhenyujian
 * @date        : 2016年1月5日 下午9:05:03 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class CourseUpdateMsgToStu extends WechatTemplateMsg{
	
	private Integer orgId;
	private String openId;
	
	private String orgName;
	private String courseName;
	private String studentName;
	private Integer lessonNo;
	private Long oldLessonStartTime;
	private Long oldLessonEndTime;
	private Long newLessonStartTime;
	private Long newLessonEndTime;
	private String newTeacherName;// 新老师名称  老师未发生改变时传null
	private String newClassroom;// 新教室名称  教室未发生改变时传null
	private String orgMobile;
	
	
	
	public CourseUpdateMsgToStu(){
		this.msgType = WechateTemplateMsgType.COURSE_UPDATE_TO_STU;
	}
	
	
	
	/**
	 * @Description  : 创建微信模板消息 用于调用微信api
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:50:29 
	 *
	 * @Return       : String
	 */
	public String buildTemplateMsg(String templateId){
		SimpleDateFormat daySdf = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat timeSdf = new SimpleDateFormat("HH:mm");
		
		this.first = String.format("【%s】,您好:\n\n您在【%s】的【%s】【第%s次课】的上课信息有变动。\n",
									studentName, orgName, courseName, lessonNo);
		if(StringUtils.isNotBlank(newTeacherName) || StringUtils.isNotBlank(newClassroom)){
			StringBuilder builder = new StringBuilder();
			builder.append(this.first);
			builder.append("\n调整内容:");
			if(StringUtils.isNotBlank(newClassroom)){
				builder.append("\n教室,变更为").append(newClassroom);
			}
			if(StringUtils.isNotBlank(newTeacherName)){
				builder.append("\n老师,变更为").append(newTeacherName);
			}
			builder.append("\n");
			this.first = builder.toString();
		}
		
		this.remark = String.format("\n请及时确认调课情况，如有疑问请致电【%s】", orgMobile);
		
		JSONObject data = new JSONObject();
		data.put("keyword1", getTemplateMsgNode( courseName ) );
		data.put("keyword2", getTemplateMsgNode( String.format( "%s %s - %s", 
																daySdf.format(new Date(oldLessonStartTime)),
																timeSdf.format(new Date(oldLessonStartTime)),
																timeSdf.format(new Date(oldLessonEndTime))) ) );
		
		data.put("keyword3", getTemplateMsgNode( String.format( "%s %s - %s", 
																daySdf.format(new Date(newLessonStartTime)),
																timeSdf.format(new Date(newLessonStartTime)),
																timeSdf.format(new Date(newLessonEndTime))) ) );
		
		return super.buildBaseTemplateMsg(openId, templateId, data).toString();
	}
	
	
	
	/**
	 * @Description  : json转换成对象
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:30 
	 *
	 * @Return       : CourseStartNoticeMsg
	 */
	public static CourseUpdateMsgToStu fromJsonStr(String jsonStr){
		CourseUpdateMsgToStu msg = new CourseUpdateMsgToStu();
		
		JSONObject json = JSONObject.fromObject(jsonStr);
		msg.fillBaseInfo(jsonStr);
		msg.setOrgId( json.optInt("orgId") );
		msg.setOpenId( json.getString("openId"));
		
		msg.setOrgName( json.optString("orgName") );
		msg.setCourseName( json.optString("courseName") );
		msg.setStudentName( json.optString("studentName") );
		msg.setLessonNo( json.optInt("lessonNo") );
		msg.setOldLessonStartTime( json.optLong("oldLessonStartTime") );
		msg.setOldLessonEndTime( json.optLong("oldLessonEndTime") );
		msg.setNewLessonStartTime( json.optLong("newLessonStartTime") );
		msg.setNewLessonEndTime( json.optLong("newLessonEndTime") );
		msg.setNewClassroom( json.optString("newClassroom") );
		msg.setNewTeacherName( json.optString("newTeacherName") );
		msg.setOrgMobile( json.optString("orgMobile") );
		
		return msg;
	}
	
	
	
	/**
	 * @Description  : 对象转换成json
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:38 
	 *
	 * @Return       : String
	 */
	public String toJsonStr(){
		JSONObject json = super.getBaseJson();
		json.put("orgId", checkNull(this.orgId) );
		json.put("openId", checkNull(this.openId));

		json.put("orgName", checkNull(this.orgName));
		json.put("courseName", checkNull(this.courseName));
		json.put("studentName", checkNull(this.studentName));
		json.put("lessonNo", checkNull(this.lessonNo));
		json.put("oldLessonStartTime", checkNull(this.oldLessonStartTime));
		json.put("oldLessonEndTime", checkNull(this.oldLessonEndTime));
		json.put("newLessonStartTime", checkNull(this.newLessonStartTime));
		json.put("newLessonEndTime", checkNull(this.newLessonEndTime));
		json.put("newClassroom", checkNull(this.newClassroom));
		json.put("newTeacherName", checkNull(this.newTeacherName));
		json.put("orgMobile", checkNull(this.orgMobile));
		
		return json.toString();
	}
	
	
	public void setOrgId(Integer orgId){
		this.orgId = orgId;
	}
	public void setOrgId(Long orgId){
		this.orgId = Integer.parseInt(orgId.toString());
	}
}

