
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.dto.menu;

import java.util.Arrays;
import java.util.List;

import com.baijia.tianxiao.util.GenericsUtils;

import com.google.common.collect.Lists;
import lombok.Data;
import net.sf.json.JSONObject;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 22, 2016
 * @Desc 底部菜单栏对象
 */
@Data
public class Menu {

    private List<Button> button;

    public void addButton(Button...subButtons) {
        if (GenericsUtils.notNullAndEmpty(subButtons)) {
            if (button == null) {
                this.button = Lists.newArrayList();
            }
            button.addAll(Arrays.asList(subButtons));
        }
    }

    /**
     * 格式保持微信自定义菜单查询接口保持一致
     * 
     * @return
     */
    public String toWeChatJson() {
        JSONObject menuRoot = new JSONObject();
        menuRoot.put("menu", JSONObject.fromObject(this));
        return menuRoot.toString();
    }

}
