
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.dto.common;

import com.baijia.tianxiao.sal.wechat.util.ValidationUtils;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Dec 3, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@Slf4j
public class WechatMessagePayload {

    public final static Integer FROM_WECHAT = 0;
    public final static Integer FROM_IM = 1;

    private Integer lastChatOrgId; // 用户最后进行对话的机构id
    private Long lastChatTime = System.currentTimeMillis(); // 用户发送的最后一条消息的时间戳
    private Integer fromType; // 聊天发起页 0:微信公众号对话框 1:h5 IM页面

    public static final String payloadFormat = "{'lastChatOrgId':%s,'fromType':%s,'lastChatTime':%s}";

    public static String instanceJsonPayloadFromIM(Integer lastChatOrgId) {
        return String.format(payloadFormat, lastChatOrgId, FROM_IM, System.currentTimeMillis());
    }

    public static String instanceJsonPayloadFromWeChat(Integer lastChatOrgId) {
        return String.format(payloadFormat, lastChatOrgId, FROM_WECHAT, System.currentTimeMillis());
    }

    public static String instanceJsonPayload(Integer lastChatOrgId, Integer fromType) {
        return String.format(payloadFormat, lastChatOrgId, fromType, System.currentTimeMillis());
    }

    public static WechatMessagePayload createWechatMessagePayload(String jsonInfo) {
        try {
            jsonInfo = preCheck(jsonInfo);
            log.info("json is :{} ", jsonInfo);
            return (WechatMessagePayload) JSONObject.toBean(JSONObject.fromObject(jsonInfo),
                WechatMessagePayload.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * @param jsonInfo
     * @return
     */
    private static String preCheck(String jsonInfo) {
        log.info("jsonInfo is :{} ", jsonInfo);
        if (ValidationUtils.isNumber(jsonInfo)) {
            return instanceJsonPayloadFromIM(GenericsUtils.getNumValueFromStr(Integer.class, jsonInfo));
        }
        return jsonInfo;
    }

    public static void main(String[] args) {

        System.out.println(preCheck("62789"));

        String jsonStr = WechatMessagePayload.instanceJsonPayload(1234, 2);
        System.out.print(jsonStr);

        WechatMessagePayload createWechatMessagePayload = WechatMessagePayload.createWechatMessagePayload(jsonStr);

        System.out.println(createWechatMessagePayload);
    }

    /**
     * @param message
     * @return
     */
    public static String getImMarkKey(String fromUserName) {
        return fromUserName + "_IM_LAST_CHAT";
    }

    /**
     * @param message
     * @return
     */
    public static String getKey(String fromUserName) {
        return fromUserName + "_LAST_CHAT";
    }

}
