/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant.custommenu;

/**   
 * @title       : WechatMenuBtnType 
 * @description : 微信自定义菜单 按钮类型
 * 				  http://mp.weixin.qq.com/wiki/10/0234e39a2025342c17a7d23595c6b40a.html
 * @author      : zhenyujian
 * @date        : 2016年1月8日 下午8:24:58 
 */
public enum WechatMenuBtnType {
	
	CLICK("click"), //点击推事件
	
	VIEW("view"), //跳转URL
	
	SCANCODE_PUSH("scancode_push"), //扫码推事件
	
	SCANCODE_WAITMSG("scancode_waitmsg"), //扫码推事件且弹出“消息接收中”提示框
	
	PICSYSPHOTO("pic_sysphoto"), //弹出系统拍照发图
	
	PIC_PHOTO_OR_ALBUM("pic_photo_or_album"), //弹出拍照或者相册发图
	
	PIC_WIXIN("pic_weixin"), //弹出微信相册发图器
	
	LOCATION_SELECT("location_select"), //弹出地理位置选择器
	
	MEDIA_ID("media_id"), //下发素材消息（除文本消息）
	
	VIEW_LIMITED("view_limited"), //跳转图文消息URL
	;

    private String value;
    
    private WechatMenuBtnType(String value) {
        this.value = value;
    }
    public String getValue() {
        return this.value;
    }
    
}

