/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import java.util.Date;
import java.util.HashSet;
import java.util.List;

import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansDetailDto;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansListDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**   
 * @title       : FansService 
 * @description : 微信粉丝相关
 * @author      : zhenyujian
 * @date        : 2015年12月12日 下午8:45:57 
 */
public interface FansService {
	
	/**
	 * @Description  : 判断是否需要进行粉丝同步操作
	 * @Author       : zhenyujian
	 */
	public boolean isNeedToSync(int orgId);
	
	
	/**
	 * @Description  : 分页查询 粉丝列表 
	 * @Author       : zhenyujian
	 */
	public FansListDto listFans(Integer orgId, String searchText, PageDto pageDto) throws CustomException;
	
	
	/**
	 * @Description  : 查询 粉丝详情 
	 * @Author       : zhenyujian
	 */
	public FansDetailDto getFansDetail(String openId);
	
	
	/**
	 * @Description  : 数据同步(从微信同步到本地) 微信粉丝 (全量同步)
	 * @Author       : zhenyujian
	 */
	public void syncFansFullAmount(String authorizerAppId);
	
	
	/**
	 * @Description  : 数据同步(从微信同步到本地) 微信粉丝 (增量同步)
	 * @Author       : zhenyujian
	 */
	public Integer syncFansIncrement(String authorizerAppId);
	
	
	/**
	 * @Description  : 给粉丝设置备注 (会调用微信接口) 
	 * @Author       : zhenyujian
	 */
	public void remark(Integer orgId, String openId, String remark);
	
	
	/**
	 * @Description  : 保存、更新 粉丝 
	 * @Author       : zhenyujian
	 */
	public void saveOrUpdateFans(Fans fans);
	
	
	/**
	 * @Description  : 查询粉丝
	 * @Author       : zhenyujian
	 */
	public Fans getFans(int orgId, String openId);
	
	
	/**
	 * @Description  : 查询粉丝
	 * @Author       : zhenyujian
	 */
	public Fans getFans(String openId);
	
	
	/**
	 * @Description  : 批量保存粉丝 
	 * @Author       : zhenyujian
	 */
	public void batchSaveFans(List<Fans> fansList);
	
	
	/**
	 * @Description  : 转换微信粉丝头像地址  微信url -> 百家url 
	 * @Author       : zhenyujian
	 */
	String convertFansHeadImg(Long orgId, Fans fans);
	
	
	/**
	 * @Description  : 转换微信粉丝头像地址  微信url -> 百家url (批量)
	 * @Author       : zhenyujian
	 */
	void batchConvertFansHeadImg(String authorizerAppId);
	
	
	/**
	 * @Description  : 从微信同步指定粉丝的信息到本地
	 * @Author       : zhenyujian
	 */
	void updateFansInfo(String openId);
	
	
	
	/**
	 * @Description  : 批量修改粉丝状态为 未关注
	 * @Author       : zhenyujian
	 * @Date         : 2016年11月12日 上午11:46:19 
	 *
	 * @Return       : void
	 */
	void batchUpdateFansToUnSubscribe(String authorizerAppId, HashSet<String> openIds, Date now);
}

