/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSSDKUtils {
    private static final Logger log = LoggerFactory.getLogger(JSSDKUtils.class);
    public static String jsapi_ticket_url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";

    public static TwoTuple<String, Integer> trievalJsApiTicket(String accessToken) {
        Integer expiredTime;
        String jsApiTicket;
        block3: {
            int resultCode = 0;
            jsApiTicket = null;
            expiredTime = null;
            String url = jsapi_ticket_url.replace("ACCESS_TOKEN", accessToken);
            JSONObject jsonObject = JSSDKUtils.doGetRequest(url, null);
            if (null != jsonObject) {
                try {
                    jsApiTicket = jsonObject.getString("ticket");
                    expiredTime = jsonObject.getInt("expires_in");
                    log.info("[JSSDKUtil] jsApiTicket param:{}", (Object)jsApiTicket);
                }
                catch (JSONException e) {
                    if (0 == jsonObject.getInt("errcode")) break block3;
                    resultCode = jsonObject.getInt("errcode");
                    log.error("JSAPI_Ticket\u83b7\u53d6\u5931\u8d25 errcode:{} errmsg:{}", (Object)resultCode, (Object)jsonObject.getString("errmsg"));
                }
            }
        }
        return TupleUtil.tuple(jsApiTicket, expiredTime);
    }

    private static JSONObject doGetRequest(String url, HashMap<String, String> param) {
        String doGet = HttpClientUtils.doGet((String)url, param);
        if (GenericsUtils.isNullOrEmpty((Object)doGet)) {
            return null;
        }
        return JSONObject.fromObject((Object)doGet);
    }

    public static String sha1Encrypt(String str) {
        String signature = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(str.getBytes("UTF-8"));
            signature = JSSDKUtils.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

