/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoCallbackHandler;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.request.AuthorizationInfoCallbackRequest;
import com.baijia.tianxiao.sal.wechat.task.FansSyncJob;
import com.baijia.tianxiao.sal.wechat.task.MediaNewsSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorizationInfoCallbackHandlerImpl
implements AuthorizationInfoCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationInfoCallbackHandlerImpl.class);
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private FansService fansService;
    @Autowired
    private MediaService mediaService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handle(AuthorizationInfoCallbackRequest request) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.addAuthorizationInfo(request.getOrgId(), request.getAuthCode());
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.syncAuthorizerInfo(request.getOrgId(), authorizationInfo.getAuthorizerAppId());
        try {
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_LIST, true);
            try {
                log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - add fansSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
                TaskHelper.getInstance().addTask(new FansSyncJob(this.fansService, authorizerInfo.getAuthorizerAppId()));
            }
            catch (Exception e) {
                log.error("wechat - AuthorizationInfoCallbackHandlerImpl - handle - fansSync - exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - fansSync", (Throwable)e);
        }
        try {
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA, true);
            try {
                log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - add mediaNewsSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
                TaskHelper.getInstance().addTask(new MediaNewsSyncJob(this.mediaService, authorizerInfo.getAuthorizerAppId(), this.authorizerInfoService));
            }
            catch (Exception e) {
                log.error("wechat - AuthorizationInfoCallbackHandlerImpl - handle - fansSync - exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - fansSync", (Throwable)e);
        }
        log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - request:{}", (Object)request);
    }

    @Override
    public void handleTest(AuthorizationInfoCallbackRequest request) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.addAuthorizationInfo(request.getOrgId(), request.getAuthCode());
        this.authorizerInfoService.syncAuthorizerInfo(request.getOrgId(), authorizationInfo.getAuthorizerAppId());
    }
}

