/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.statistics;

import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSummaryDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.statistics.DataStatisticsApiCaller;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStatisticsApiHelper {
    private static final Logger log = LoggerFactory.getLogger(DataStatisticsApiHelper.class);
    private static final ExecutorService executor = Executors.newFixedThreadPool(5);

    public static FansSCDto getFansSCDto(String accessToken, Date beginDate, Date endDate, Date dateForCumulate) throws ParseException {
        JSONObject ytCumulateRootNode;
        JSONArray ytCumulateArray;
        long start = System.currentTimeMillis();
        FansSCDto dto = new FansSCDto();
        dto.setStartDate(DateUtil.getStrByDate((Date)beginDate));
        dto.setEndDate(DateUtil.getStrByDate((Date)endDate));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        WechatApiResponse ytCumulateResp = DataStatisticsApiCaller.getFansCumulate(accessToken, dateForCumulate, dateForCumulate);
        WechatApiResponse ytSummaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, dateForCumulate, dateForCumulate);
        int cancelFansForCumulate = 0;
        int newFansForCumulate = 0;
        int totalFansForCumulate = 0;
        JSONObject ytSummaryRootNode = ytSummaryResp.getRootJSONObj();
        JSONArray ytSummaryArray = ytSummaryRootNode.getJSONArray("list");
        if (ytSummaryArray != null && ytSummaryArray.size() > 0) {
            for (int i = 0; i < ytSummaryArray.size(); ++i) {
                JSONObject obj = ytSummaryArray.getJSONObject(i);
                cancelFansForCumulate += obj.getInt("cancel_user");
                newFansForCumulate += obj.getInt("new_user");
            }
        }
        if ((ytCumulateArray = (ytCumulateRootNode = ytCumulateResp.getRootJSONObj()).getJSONArray("list")) != null && !ytCumulateArray.isEmpty()) {
            totalFansForCumulate = ytCumulateArray.getJSONObject(0).getInt("cumulate_user");
            dto.setYtDate(sdf.format(dateForCumulate));
            dto.setYtCancelFans(cancelFansForCumulate);
            dto.setYtNewFans(newFansForCumulate);
            dto.setYtFansDiff(newFansForCumulate - cancelFansForCumulate);
            dto.setYtCumulateFans(totalFansForCumulate);
        }
        ArrayList<FansSummaryDto> fansSummaryDtoList = new ArrayList<FansSummaryDto>();
        List dateList = DateUtil.getDateBetween((Date)beginDate, (Date)endDate);
        if (dateList != null && !dateList.isEmpty()) {
            LinkedHashMap<String, FansSummaryDto> symmaryMap = new LinkedHashMap<String, FansSummaryDto>();
            for (Date date : dateList) {
                FansSummaryDto fansSummaryDto = new FansSummaryDto(sdf.format(date));
                symmaryMap.put(sdf.format(date), fansSummaryDto);
            }
            boolean bContinue = DateUtil.compare((Date)DateUtil.getDiffDateTime((Date)beginDate, (int)6), (Date)endDate) || DateUtil.compare((Date)beginDate, (Date)endDate);
            ArrayList<CallableTask> tasks = new ArrayList<CallableTask>();
            while (bContinue) {
                Date tempEndDate = DateUtil.getDiffDateTime((Date)beginDate, (int)6);
                if (tempEndDate.compareTo(endDate) >= 0) {
                    tasks.add(new CallableTask(beginDate, endDate, accessToken));
                    break;
                }
                tasks.add(new CallableTask(beginDate, tempEndDate, accessToken));
                beginDate = DateUtil.getDiffDateTime((Date)tempEndDate, (int)1);
                bContinue = DateUtil.compare((Date)DateUtil.getDiffDateTime((Date)beginDate, (int)6), (Date)endDate) || DateUtil.compare((Date)beginDate, (Date)endDate);
            }
            if (tasks.size() > 0) {
                List<JSONArray> jsonArrayList = DataStatisticsApiHelper.executeTasks(tasks);
                log.info("[Fans] Cost time = " + (System.currentTimeMillis() - start) + "\u6309\u65f6\u95f4\u6bb5\u83b7\u53d6\u5fae\u4fe1\u7c89\u4e1d\u5217\u8868");
                for (JSONArray jsonArray : jsonArrayList) {
                    DataStatisticsApiHelper.setFansSummaryDtoMap(jsonArray, symmaryMap);
                }
                for (FansSummaryDto fsdto : symmaryMap.values()) {
                    fansSummaryDtoList.add(fsdto);
                }
            }
        }
        dto.setSummary(fansSummaryDtoList);
        return dto;
    }

    public static JSONArray getJSONArray(String accessToken, Date beginDate, Date endDate) {
        WechatApiResponse summaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, beginDate, endDate);
        JSONObject summaryRootNode = summaryResp.getRootJSONObj();
        JSONArray summaryArray = summaryRootNode.getJSONArray("list");
        return summaryArray;
    }

    private static void setFansSummaryDtoMap(JSONArray summaryArray, LinkedHashMap<String, FansSummaryDto> symmaryMap) {
        if (summaryArray != null & !summaryArray.isEmpty()) {
            for (int i = 0; i < summaryArray.size(); ++i) {
                JSONObject obj = summaryArray.getJSONObject(i);
                FansSummaryDto fsdto = symmaryMap.get(obj.getString("ref_date"));
                fsdto.setCancelFans(fsdto.getCancelFans() + obj.getInt("cancel_user"));
                fsdto.setNewFans(fsdto.getNewFans() + obj.getInt("new_user"));
                fsdto.setFansDiff(fsdto.getNewFans() - fsdto.getCancelFans());
                fsdto.setFlag(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<JSONArray> executeTasks(Collection<? extends Callable<JSONArray>> tasks) {
        ExecutorCompletionService<JSONArray> completionService = new ExecutorCompletionService<JSONArray>(executor);
        for (Callable<JSONArray> callable : tasks) {
            completionService.submit(callable);
        }
        ArrayList results = Lists.newArrayListWithCapacity((int)tasks.size());
        try {
            void var3_5;
            boolean bl = false;
            int n = tasks.size();
            while (var3_5 < n) {
                Future f = completionService.take();
                JSONArray retT = (JSONArray)f.get();
                results.add(retT);
                ++var3_5;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            log.error("cause error : {} ", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        return results;
    }

    static class CallableTask
    implements Callable<JSONArray> {
        private Date startDate;
        private Date endDate;
        private String accessToken;

        public CallableTask(Date startDate, Date endDate, String accessToken) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.accessToken = accessToken;
        }

        @Override
        public JSONArray call() throws Exception {
            JSONArray summaryArray = DataStatisticsApiHelper.getJSONArray(this.accessToken, this.startDate, this.endDate);
            return summaryArray;
        }
    }
}

