/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.webauthlink;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;

/**   
 * @title       : WechatWebAuthLinkBuilder 
 * @description : 微信网页授权链接
 * @author      : zhenyujian
 * @date        : 2016年1月6日 下午5:38:48 
 */
public class WechatWebAuthLinkHelper {
	
	static final String CHARSET_REDIRECT_URL = "utf8";

	/**
	 * @Description  : 获取 '网页授权' 超链接地址 见 http://mp.weixin.qq.com/wiki/17/c0f37d5704f0b64713d5d2c37b468d75.html
	 * 				   redirectUrl 非空 需要encode
	 * 				   scope 非空 
	 * 				   state在302后会被拼接在302的落地地址上
	 * @Author       : zhenyujian
	 * @CreationDate : 2016年1月6日 下午3:52:54 
	 *
	 * @Return       : String
	 */
	public static String getWebAuthLink(String appId, String redirectUrl, WebAuthScope scope, String state){
		try {
			if( !redirectUrl.contains("?scope=") && !redirectUrl.contains("&scope=")){
				StringBuilder builder = new StringBuilder(redirectUrl);
				if(!redirectUrl.contains("?")){
					builder.append("?");
				}
				builder.append("&scope=").append(scope.getValue());
				redirectUrl = builder.toString();
			} 
			 
			redirectUrl = URLEncoder.encode( redirectUrl , CHARSET_REDIRECT_URL);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		
		StringBuilder urlBuilder = new StringBuilder();
		urlBuilder.append("https://open.weixin.qq.com/connect/oauth2/authorize?");
		urlBuilder.append("&appid=").append( appId );
		urlBuilder.append("&redirect_uri=").append(redirectUrl);
		urlBuilder.append("&response_type=code");
		urlBuilder.append("&scope=").append( scope.getValue() );
		urlBuilder.append("&state=").append( StringUtils.isNotBlank(state)? state:"" );
		urlBuilder.append("&component_appid=").append(WechatProperties.getOpenPlatformInfo().getAppId());
		urlBuilder.append("#wechat_redirect");
		return urlBuilder.toString();
	}
	
	
	public static String getWebAuthLink(String appId, String redirectUrl, WebAuthScope scope){
		return getWebAuthLink(appId, redirectUrl, scope, null);
	}
	
}

