/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.statistics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.google.common.collect.Maps;

/**   
 * @title       : DataStatisticsApiCaller 
 * @description : 微信公众平台 数据统计相关接口 
 * 				  http://mp.weixin.qq.com/wiki/15/88726a421bfc54654a3095821c3ca3bb.html
 * @author      : zhenyujian
 * @date        : 2015年12月17日 下午1:58:50 
 */
public class DataStatisticsApiCaller {

	
	
	/**
	 * @Description  : 获取用户增减数据 
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月18日 下午1:58:52 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse getFansSummary(String accessToken, Date beginDate, Date endDate){
		String url = "https://api.weixin.qq.com/datacube/getusersummary?access_token=" + accessToken;
		
		Map<String, Object> params = Maps.newHashMap();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		params.put("begin_date", sdf.format(beginDate) );
		params.put("end_date", sdf.format(endDate) );
        
        return WechatRemoteCallHelper.postJson(url, params);
	}
	
	
	
	/**
	 * @Description  : 获取累计用户数据
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月18日 下午1:58:55 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse getFansCumulate(String accessToken, Date beginDate, Date endDate){
		String url = "https://api.weixin.qq.com/datacube/getusercumulate?access_token=" + accessToken;
		
		Map<String, Object> params = Maps.newHashMap();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		params.put("begin_date", sdf.format(beginDate) );
		params.put("end_date", sdf.format(endDate) );
		
        return WechatRemoteCallHelper.postJson(url, params);
	}
	
}

