/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer;

import java.util.Map;

import net.sf.json.JSONObject;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.google.common.collect.Maps;

/**   
 * @Title       : OpenPlatformApiCaller 
 * @Description : 微信公众平台 发送消息 - 客服相关接口
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 上午11:01:58 
 */
public class CustomerServiceApiCaller {
	
	
	
	/**
	 * @Description  : 发送文本消息
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月3日 上午11:03:49 
	 *
	 * @Return       : 
	 */
	public static WechatApiResponse sendTextMsg(String accessToken, String toOpenId, String content)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken;

        JSONObject textMap = new JSONObject();
        textMap.put("content", content);

        JSONObject json = new JSONObject();
        json.put("touser", toOpenId);
        json.put("msgtype", "text");
        json.put("text", textMap);
        
        String jsonStr = json.toString();
        jsonStr = jsonStr.replace("\"content\":null", "\"content\":\"null\"");
        
        return WechatRemoteCallHelper.postJsonStr(url, jsonStr, true);
    }
	
	
	
	/**
	 * @Description  : 发送图片消息
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月5日 上午12:35:05 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse sendImageMsg(String accessToken, String toOpenId, String mediaId)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken;

        Map<String, String> imageMap = Maps.newHashMap();
        imageMap.put("media_id", mediaId);

        Map<String, Object> params = Maps.newHashMap();
        params.put("touser", toOpenId);
        params.put("msgtype", "image");
        params.put("image", imageMap);
        return WechatRemoteCallHelper.postJson(url, params);
    }
	
	
	/**
	 * @Description  : 发送语音消息
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月11日 下午1:28:47 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse sendVoiceMsg(String accessToken, String toOpenId, String mediaId)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken;

        Map<String, String> voiceMap = Maps.newHashMap();
        voiceMap.put("media_id", mediaId);

        Map<String, Object> params = Maps.newHashMap();
        params.put("touser", toOpenId);
        params.put("msgtype", "voice");
        params.put("voice", voiceMap);
        return WechatRemoteCallHelper.postJson(url, params);
    }
	
	
	
	
	/**
	 * @Description  : 发送图文消息
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月5日 上午12:25:48 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse sendNewsMsg(String accessToken, String toOpenId, String mediaId)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken;

        Map<String, String> imageMap = Maps.newHashMap();
        imageMap.put("media_id", mediaId);

        Map<String, Object> params = Maps.newHashMap();
        params.put("touser", toOpenId);
        params.put("msgtype", "mpnews");
        params.put("mpnews", imageMap);
        return WechatRemoteCallHelper.postJson(url, params);
    }
}

